/*
 * Decompiled with CFR 0.152.
 */
package net.webmo.symmetry.util;

import net.webmo.symmetry.util.Matrix4D;

public class Point3D {
    public static final Point3D O = new Point3D(0.0, 0.0, 0.0);
    public double x;
    public double y;
    public double z;

    public Point3D() {
        this.x = 0.0;
        this.y = 0.0;
        this.z = 0.0;
    }

    public Point3D(Point3D other) {
        this.x = other.x;
        this.y = other.y;
        this.z = other.z;
    }

    public Point3D(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public boolean unit() {
        double len = this.length();
        if (len != 0.0) {
            this.x /= len;
            this.y /= len;
            this.z /= len;
            return true;
        }
        return false;
    }

    public Point3D add(Point3D other) {
        return new Point3D(this.x + other.x, this.y + other.y, this.z + other.z);
    }

    public Point3D sub(Point3D other) {
        return new Point3D(this.x - other.x, this.y - other.y, this.z - other.z);
    }

    public Point3D mult(double factor) {
        return new Point3D(this.x * factor, this.y * factor, this.z * factor);
    }

    public Point3D crossProd(Point3D other) {
        Point3D result = new Point3D();
        result.x = other.z * this.y - other.y * this.z;
        result.y = other.x * this.z - other.z * this.x;
        result.z = other.y * this.x - other.x * this.y;
        return result;
    }

    public double dotProd(Point3D other) {
        return other.x * this.x + other.y * this.y + other.z * this.z;
    }

    public double distance(Point3D other) {
        Point3D c1 = this;
        Point3D c2 = other;
        return Math.sqrt(Math.pow(c2.x - c1.x, 2.0) + Math.pow(c2.y - c1.y, 2.0) + Math.pow(c2.z - c1.z, 2.0));
    }

    public double angleBetween(Point3D other) {
        return Math.acos(this.dotProd(other) / (this.length() * other.length()));
    }

    public Point3D rotate(Point3D rotCenter, Point3D rotateAxis, double angle) {
        Point3D oldCoords = this;
        Point3D newCoords = new Point3D();
        Point3D rotAxis = new Point3D(rotateAxis);
        rotAxis.unit();
        oldCoords = oldCoords.sub(rotCenter);
        double c = Math.cos(angle);
        double s = Math.sin(angle);
        Matrix4D rotateOp = new Matrix4D();
        rotateOp.identity();
        double[][] m = rotateOp.matrix;
        m[0][0] = c + (1.0 - c) * rotAxis.x * rotAxis.x;
        m[0][1] = (1.0 - c) * rotAxis.x * rotAxis.y - s * rotAxis.z;
        m[0][2] = (1.0 - c) * rotAxis.x * rotAxis.z + s * rotAxis.y;
        m[1][0] = (1.0 - c) * rotAxis.x * rotAxis.y + s * rotAxis.z;
        m[1][1] = c + (1.0 - c) * rotAxis.y * rotAxis.y;
        m[1][2] = (1.0 - c) * rotAxis.z * rotAxis.y - s * rotAxis.x;
        m[2][0] = (1.0 - c) * rotAxis.x * rotAxis.z - s * rotAxis.y;
        m[2][1] = (1.0 - c) * rotAxis.y * rotAxis.z + s * rotAxis.x;
        m[2][2] = c + (1.0 - c) * rotAxis.z * rotAxis.z;
        newCoords.x = m[0][0] * oldCoords.x + m[0][1] * oldCoords.y + m[0][2] * oldCoords.z;
        newCoords.y = m[1][0] * oldCoords.x + m[1][1] * oldCoords.y + m[1][2] * oldCoords.z;
        newCoords.z = m[2][0] * oldCoords.x + m[2][1] * oldCoords.y + m[2][2] * oldCoords.z;
        newCoords = newCoords.add(rotCenter);
        return newCoords;
    }

    public String toString() {
        return String.format("(%f, %f, %f)", this.x, this.y, this.z);
    }

    public boolean equals(Object other) {
        if (other instanceof Point3D) {
            Point3D otherPt = (Point3D)other;
            return this.distance(otherPt) < 1.0E-5;
        }
        return false;
    }

    public static Point3D closestPointInPlane(Point3D point, Point3D planePoint, Point3D normal) {
        double d = -(normal.x * planePoint.x + normal.y * planePoint.y + normal.z * planePoint.z);
        double t = -((normal.x * point.x + normal.y * point.y + normal.z * point.z + d) / (normal.x * normal.x + normal.y * normal.y + normal.z * normal.z));
        return new Point3D(point.x + normal.x * t, point.y + normal.y * t, point.z + normal.z * t);
    }

    public static Point3D closestPointOnAxis(Point3D point, Point3D axisPoint, Point3D axis) {
        axis = new Point3D(axis.x, axis.y, axis.z);
        axis.unit();
        return axisPoint.add(axis.mult(point.sub(axisPoint).dotProd(axis)));
    }
}

