/*
 * Decompiled with CFR 0.152.
 */
package net.webmo.symmetry.util;

public class Matrix4D {
    public double[][] matrix = new double[4][4];
    private double[][] tempMatrix = new double[4][4];

    public Matrix4D() {
        this.identity();
    }

    public void identity() {
        this.matrix[0][0] = 1.0;
        this.matrix[1][0] = 0.0;
        this.matrix[2][0] = 0.0;
        this.matrix[3][0] = 0.0;
        this.matrix[0][1] = 0.0;
        this.matrix[1][1] = 1.0;
        this.matrix[2][1] = 0.0;
        this.matrix[3][1] = 0.0;
        this.matrix[0][2] = 0.0;
        this.matrix[1][2] = 0.0;
        this.matrix[2][2] = 1.0;
        this.matrix[3][2] = 0.0;
        this.matrix[0][3] = 0.0;
        this.matrix[1][3] = 0.0;
        this.matrix[2][3] = 0.0;
        this.matrix[3][3] = 1.0;
    }

    public void mult(Matrix4D matrix_in) {
        this.tempMatrix[0][0] = matrix_in.matrix[0][0] * this.matrix[0][0] + matrix_in.matrix[0][1] * this.matrix[1][0] + matrix_in.matrix[0][2] * this.matrix[2][0] + matrix_in.matrix[0][3] * this.matrix[3][0];
        this.tempMatrix[1][0] = matrix_in.matrix[1][0] * this.matrix[0][0] + matrix_in.matrix[1][1] * this.matrix[1][0] + matrix_in.matrix[1][2] * this.matrix[2][0] + matrix_in.matrix[1][3] * this.matrix[3][0];
        this.tempMatrix[2][0] = matrix_in.matrix[2][0] * this.matrix[0][0] + matrix_in.matrix[2][1] * this.matrix[1][0] + matrix_in.matrix[2][2] * this.matrix[2][0] + matrix_in.matrix[2][3] * this.matrix[3][0];
        this.tempMatrix[3][0] = matrix_in.matrix[3][0] * this.matrix[0][0] + matrix_in.matrix[3][1] * this.matrix[1][0] + matrix_in.matrix[3][2] * this.matrix[2][0] + matrix_in.matrix[3][3] * this.matrix[3][0];
        this.tempMatrix[0][1] = matrix_in.matrix[0][0] * this.matrix[0][1] + matrix_in.matrix[0][1] * this.matrix[1][1] + matrix_in.matrix[0][2] * this.matrix[2][1] + matrix_in.matrix[0][3] * this.matrix[3][1];
        this.tempMatrix[1][1] = matrix_in.matrix[1][0] * this.matrix[0][1] + matrix_in.matrix[1][1] * this.matrix[1][1] + matrix_in.matrix[1][2] * this.matrix[2][1] + matrix_in.matrix[1][3] * this.matrix[3][1];
        this.tempMatrix[2][1] = matrix_in.matrix[2][0] * this.matrix[0][1] + matrix_in.matrix[2][1] * this.matrix[1][1] + matrix_in.matrix[2][2] * this.matrix[2][1] + matrix_in.matrix[2][3] * this.matrix[3][1];
        this.tempMatrix[3][1] = matrix_in.matrix[3][0] * this.matrix[0][1] + matrix_in.matrix[3][1] * this.matrix[1][1] + matrix_in.matrix[3][2] * this.matrix[2][1] + matrix_in.matrix[3][3] * this.matrix[3][1];
        this.tempMatrix[0][2] = matrix_in.matrix[0][0] * this.matrix[0][2] + matrix_in.matrix[0][1] * this.matrix[1][2] + matrix_in.matrix[0][2] * this.matrix[2][2] + matrix_in.matrix[0][3] * this.matrix[3][2];
        this.tempMatrix[1][2] = matrix_in.matrix[1][0] * this.matrix[0][2] + matrix_in.matrix[1][1] * this.matrix[1][2] + matrix_in.matrix[1][2] * this.matrix[2][2] + matrix_in.matrix[1][3] * this.matrix[3][2];
        this.tempMatrix[2][2] = matrix_in.matrix[2][0] * this.matrix[0][2] + matrix_in.matrix[2][1] * this.matrix[1][2] + matrix_in.matrix[2][2] * this.matrix[2][2] + matrix_in.matrix[2][3] * this.matrix[3][2];
        this.tempMatrix[3][2] = matrix_in.matrix[3][0] * this.matrix[0][2] + matrix_in.matrix[3][1] * this.matrix[1][2] + matrix_in.matrix[3][2] * this.matrix[2][2] + matrix_in.matrix[3][3] * this.matrix[3][2];
        this.tempMatrix[0][3] = matrix_in.matrix[0][0] * this.matrix[0][3] + matrix_in.matrix[0][1] * this.matrix[1][3] + matrix_in.matrix[0][2] * this.matrix[2][3] + matrix_in.matrix[0][3] * this.matrix[3][3];
        this.tempMatrix[1][3] = matrix_in.matrix[1][0] * this.matrix[0][3] + matrix_in.matrix[1][1] * this.matrix[1][3] + matrix_in.matrix[1][2] * this.matrix[2][3] + matrix_in.matrix[1][3] * this.matrix[3][3];
        this.tempMatrix[2][3] = matrix_in.matrix[2][0] * this.matrix[0][3] + matrix_in.matrix[2][1] * this.matrix[1][3] + matrix_in.matrix[2][2] * this.matrix[2][3] + matrix_in.matrix[2][3] * this.matrix[3][3];
        this.tempMatrix[3][3] = matrix_in.matrix[3][0] * this.matrix[0][3] + matrix_in.matrix[3][1] * this.matrix[1][3] + matrix_in.matrix[3][2] * this.matrix[2][3] + matrix_in.matrix[3][3] * this.matrix[3][3];
        System.arraycopy(this.tempMatrix[0], 0, this.matrix[0], 0, 4);
        System.arraycopy(this.tempMatrix[1], 0, this.matrix[1], 0, 4);
        System.arraycopy(this.tempMatrix[2], 0, this.matrix[2], 0, 4);
        System.arraycopy(this.tempMatrix[3], 0, this.matrix[3], 0, 4);
    }

    public void mult(double k) {
        int i = 0;
        while (i < 4) {
            int j = 0;
            while (j < 4) {
                double[] dArray = this.matrix[i];
                int n = j++;
                dArray[n] = dArray[n] * k;
            }
            ++i;
        }
    }

    public void invert() {
        int n = 4;
        int[] indx = new int[4];
        double[] col = new double[4];
        this.ludcmp(indx);
        int j = 1;
        while (j <= n) {
            int i = 1;
            while (i <= n) {
                col[i - 1] = 0.0;
                ++i;
            }
            col[j - 1] = 1.0;
            this.lubksb(indx, col);
            i = 1;
            while (i <= n) {
                this.tempMatrix[i - 1][j - 1] = col[i - 1];
                ++i;
            }
            ++j;
        }
        System.arraycopy(this.tempMatrix[0], 0, this.matrix[0], 0, 4);
        System.arraycopy(this.tempMatrix[1], 0, this.matrix[1], 0, 4);
        System.arraycopy(this.tempMatrix[2], 0, this.matrix[2], 0, 4);
        System.arraycopy(this.tempMatrix[3], 0, this.matrix[3], 0, 4);
    }

    private void ludcmp(int[] indx) {
        int j;
        double big;
        int n = 4;
        double[] vv = new double[4];
        int imax = 0;
        double d = 1.0;
        int i = 1;
        while (i <= n) {
            big = 0.0;
            j = 1;
            while (j <= n) {
                double d2;
                double temp = Math.abs(this.matrix[i - 1][j - 1]);
                if (d2 > big) {
                    big = temp;
                }
                ++j;
            }
            if (big == 0.0) {
                return;
            }
            vv[i - 1] = 1.0 / big;
            ++i;
        }
        j = 1;
        while (j <= n) {
            double dum;
            int k;
            double sum;
            i = 1;
            while (i < j) {
                sum = this.matrix[i - 1][j - 1];
                k = 1;
                while (k < i) {
                    sum -= this.matrix[i - 1][k - 1] * this.matrix[k - 1][j - 1];
                    ++k;
                }
                this.matrix[i - 1][j - 1] = sum;
                ++i;
            }
            big = 0.0;
            i = j;
            while (i <= n) {
                double d3;
                sum = this.matrix[i - 1][j - 1];
                k = 1;
                while (k < j) {
                    sum -= this.matrix[i - 1][k - 1] * this.matrix[k - 1][j - 1];
                    ++k;
                }
                this.matrix[i - 1][j - 1] = sum;
                dum = vv[i - 1] * Math.abs(sum);
                if (d3 >= big) {
                    big = dum;
                    imax = i;
                }
                ++i;
            }
            if (j != imax) {
                k = 1;
                while (k <= n) {
                    dum = this.matrix[imax - 1][k - 1];
                    this.matrix[imax - 1][k - 1] = this.matrix[j - 1][k - 1];
                    this.matrix[j - 1][k - 1] = dum;
                    ++k;
                }
                d = -d;
                vv[imax - 1] = vv[j - 1];
            }
            indx[j - 1] = imax;
            if (j != n) {
                dum = 1.0 / this.matrix[j - 1][j - 1];
                i = j + 1;
                while (i <= n) {
                    double[] dArray = this.matrix[i - 1];
                    int n2 = j - 1;
                    dArray[n2] = dArray[n2] * dum;
                    ++i;
                }
            }
            ++j;
        }
    }

    private void lubksb(int[] indx, double[] b) {
        int j;
        double sum;
        int n = 4;
        int ii = 0;
        int i = 1;
        while (i <= n) {
            int ip = indx[i - 1];
            sum = b[ip - 1];
            b[ip - 1] = b[i - 1];
            if (ii != 0) {
                j = ii;
                while (j <= i - 1) {
                    sum -= this.matrix[i - 1][j - 1] * b[j - 1];
                    ++j;
                }
            } else if (sum != 0.0) {
                ii = i;
            }
            b[i - 1] = sum;
            ++i;
        }
        i = n;
        while (i >= 1) {
            sum = b[i - 1];
            j = i + 1;
            while (j <= n) {
                sum -= this.matrix[i - 1][j - 1] * b[j - 1];
                ++j;
            }
            b[i - 1] = sum / this.matrix[i - 1][i - 1];
            --i;
        }
    }

    public void diag(double[] d, Matrix4D v) {
        this.jacobi(d, v);
        this.eigsrt(d, v);
    }

    private void jacobi(double[] d, Matrix4D v) {
        int n = 3;
        double[] b = new double[3];
        double[] z = new double[3];
        v.identity();
        int ip = 0;
        while (ip < 3) {
            b[ip] = d[ip] = this.matrix[ip][ip];
            z[ip] = 0.0;
            ++ip;
        }
        int nrot = 0;
        int i = 0;
        while (i < 50) {
            int iq;
            double sm = 0.0;
            ip = 0;
            while (ip < 2) {
                iq = ip + 1;
                while (iq < 3) {
                    sm += Math.abs(this.matrix[ip][iq]);
                    ++iq;
                }
                ++ip;
            }
            if (sm == 0.0) {
                return;
            }
            double thresh = i < 4 ? 0.2 * sm / 9.0 : 0.0;
            ip = 0;
            while (ip < 2) {
                iq = ip + 1;
                while (iq < 3) {
                    double g = 100.0 * Math.abs(this.matrix[ip][iq]);
                    if (i > 4 && Math.abs(d[ip]) + g == Math.abs(d[ip]) && Math.abs(d[iq]) + g == Math.abs(d[iq])) {
                        this.matrix[ip][iq] = 0.0;
                    } else if (Math.abs(this.matrix[ip][iq]) > thresh) {
                        double t;
                        double h = d[iq] - d[ip];
                        if (Math.abs(h) + g == Math.abs(h)) {
                            t = this.matrix[ip][iq] / h;
                        } else {
                            double theta = 0.5 * h / this.matrix[ip][iq];
                            t = 1.0 / (Math.abs(theta) + Math.sqrt(1.0 + theta * theta));
                            if (theta < 0.0) {
                                t = -t;
                            }
                        }
                        double c = 1.0 / Math.sqrt(1.0 + t * t);
                        double s = t * c;
                        double tau = s / (1.0 + c);
                        h = t * this.matrix[ip][iq];
                        int n2 = ip;
                        z[n2] = z[n2] - h;
                        int n3 = iq;
                        z[n3] = z[n3] + h;
                        int n4 = ip;
                        d[n4] = d[n4] - h;
                        int n5 = iq;
                        d[n5] = d[n5] + h;
                        this.matrix[ip][iq] = 0.0;
                        int j = 0;
                        while (j <= ip - 1) {
                            g = this.matrix[j][ip];
                            h = this.matrix[j][iq];
                            this.matrix[j][ip] = g - s * (h + g * tau);
                            this.matrix[j][iq] = h + s * (g - h * tau);
                            ++j;
                        }
                        j = ip + 1;
                        while (j <= iq - 1) {
                            g = this.matrix[ip][j];
                            h = this.matrix[j][iq];
                            this.matrix[ip][j] = g - s * (h + g * tau);
                            this.matrix[j][iq] = h + s * (g - h * tau);
                            ++j;
                        }
                        j = iq + 1;
                        while (j < 3) {
                            g = this.matrix[ip][j];
                            h = this.matrix[iq][j];
                            this.matrix[ip][j] = g - s * (h + g * tau);
                            this.matrix[iq][j] = h + s * (g - h * tau);
                            ++j;
                        }
                        j = 0;
                        while (j < 3) {
                            g = v.matrix[j][ip];
                            h = v.matrix[j][iq];
                            v.matrix[j][ip] = g - s * (h + g * tau);
                            v.matrix[j][iq] = h + s * (g - h * tau);
                            ++j;
                        }
                        ++nrot;
                    }
                    ++iq;
                }
                ++ip;
            }
            ip = 0;
            while (ip < 3) {
                int n6 = ip;
                b[n6] = b[n6] + z[ip];
                d[ip] = b[ip];
                z[ip] = 0.0;
                ++ip;
            }
            ++i;
        }
    }

    private void eigsrt(double[] d, Matrix4D v) {
        int n = 3;
        int i = 0;
        while (i < 2) {
            int k = i;
            double p = d[k];
            int j = i + 1;
            while (j < 3) {
                if (d[j] >= p) {
                    k = j;
                    p = d[k];
                }
                ++j;
            }
            if (k != i) {
                d[k] = d[i];
                d[i] = p;
                j = 0;
                while (j < 3) {
                    p = v.matrix[j][i];
                    v.matrix[j][i] = v.matrix[j][k];
                    v.matrix[j][k] = p;
                    ++j;
                }
            }
            ++i;
        }
    }
}

