/*
 * Decompiled with CFR 0.152.
 */
package net.webmo.symmetry.molecule;

import java.util.List;
import net.webmo.symmetry.util.Point3D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Atom {
    private Point3D position;
    private AtomicProperties properties;
    private boolean isSymmetryUnique;

    public Atom() {
    }

    public Atom(Atom other) {
        this.position = new Point3D(other.position);
        this.properties = other.properties;
        this.isSymmetryUnique = other.isSymmetryUnique;
    }

    public Atom(int number, double x, double y, double z) {
        this.position = new Point3D(x, y, z);
        if (number < 1 || number > AtomicProperties.values().length) {
            System.err.println("No element with atomic number " + number + " was found.");
            this.properties = AtomicProperties.ERROR;
        } else {
            this.properties = AtomicProperties.values()[number];
        }
        this.isSymmetryUnique = true;
    }

    public Atom(String symbol, double x, double y, double z) {
        this.position = new Point3D(x, y, z);
        try {
            this.properties = AtomicProperties.valueOf(symbol);
        }
        catch (IllegalArgumentException e) {
            System.err.println("No element with atomic symbol '" + symbol + "' was found.");
            this.properties = AtomicProperties.ERROR;
        }
        this.isSymmetryUnique = true;
    }

    public String getSymbol() {
        return this.properties.symbol();
    }

    public int getNumber() {
        return this.properties.number();
    }

    public double getMass() {
        return this.properties.mass();
    }

    public Point3D getPosition() {
        return this.position;
    }

    public boolean isSymmetryUnique() {
        return this.isSymmetryUnique;
    }

    public void setPosition(Point3D newPos) {
        this.position = newPos;
    }

    public void setSymmetryUnique(boolean isUnique) {
        this.isSymmetryUnique = isUnique;
    }

    public Atom findClosestAtom(List<Atom> closeAtoms) {
        Atom closestAtom = null;
        double shortestDistanceSq = Double.MAX_VALUE;
        Point3D thisPos = this.getPosition();
        for (Atom testAtom : closeAtoms) {
            Point3D testPos = testAtom.getPosition();
            double dx = thisPos.x - testPos.x;
            double dy = thisPos.y - testPos.y;
            double dz = thisPos.z - testPos.z;
            double distSq = dx * dx + dy * dy + dz * dz;
            if (this.getNumber() != testAtom.getNumber() || this == testAtom || closestAtom != null && !(distSq < shortestDistanceSq)) continue;
            closestAtom = testAtom;
            shortestDistanceSq = distSq;
        }
        if (closestAtom != null) {
            return closestAtom;
        }
        return this;
    }

    public double distance(Atom other) {
        return this.getPosition().distance(other.getPosition());
    }

    public String toString() {
        String unique = this.isSymmetryUnique ? "*" : " ";
        return String.format("%s%s at %s", unique, this.getSymbol(), this.position.toString());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AtomicProperties {
        ERROR(0.0),
        H(1.0079),
        He(4.0026),
        Li(6.94),
        Be(9.0122),
        B(10.81),
        C(12.011),
        N(14.0067),
        O(15.9994),
        F(18.9984),
        Ne(20.18),
        Na(22.989799),
        Mg(24.31),
        Al(28.086),
        Si(28.086),
        P(30.973801),
        S(32.060001),
        Cl(35.452999),
        Ar(39.95),
        K(39.1),
        Ca(40.08),
        Sc(44.96),
        Ti(27.88),
        V(50.94),
        Cr(52.0),
        Mn(54.94),
        Fe(55.85),
        Co(58.93),
        Ni(58.69),
        Cu(63.55),
        Zn(65.39),
        Ga(69.72),
        Ge(72.61),
        As(74.92),
        Se(78.96),
        Br(79.903999),
        Kr(83.6),
        Rb(85.47),
        Sr(87.62),
        Y(88.91),
        Zr(91.22),
        Nb(92.9),
        Mo(95.94),
        Tc(98.0),
        Ru(101.07),
        Rh(102.01),
        Pd(106.42),
        Ag(107.87),
        Cd(112.41),
        In(114.82),
        Sn(118.71),
        Sb(121.76),
        Te(127.6),
        I(126.9),
        Xe(131.29),
        Cs(132.91),
        Ba(137.33),
        La(138.91),
        Ce(140.12),
        Pr(140.91),
        Nd(144.24),
        Pm(145.0),
        Sm(150.36),
        Eu(151.96),
        Gd(157.25),
        Tb(158.93),
        Dy(162.5),
        Ho(164.93),
        Er(167.26),
        Tm(168.93),
        Ym(173.04),
        Lu(174.97),
        Hf(178.49),
        Ta(180.95),
        W(183.84),
        Re(186.207),
        Os(190.23),
        Ir(192.22),
        Pt(195.08),
        Au(196.97),
        Hg(200.59),
        Tl(204.28),
        Pb(207.2),
        Bi(208.98),
        Po(209.0),
        At(210.0),
        Rn(222.0),
        Fr(223.0),
        Ra(226.0),
        Ac(227.0),
        Th(232.04),
        Pa(231.04),
        U(238.03),
        Np(237.0),
        Pu(244.0),
        Am(243.0),
        Cm(247.0),
        Bk(247.0),
        Cf(251.0),
        Es(252.0),
        Fm(257.0),
        Md(258.0),
        No(259.0),
        Lr(262.0);

        private double atomicMass;

        private AtomicProperties(double mass) {
            this.atomicMass = mass;
        }

        public String symbol() {
            return super.toString();
        }

        public int number() {
            return super.ordinal();
        }

        public double mass() {
            return this.atomicMass;
        }
    }
}

