/*
 * Decompiled with CFR 0.152.
 */
package net.webmo.symmetry.elements;

import net.webmo.symmetry.elements.Rotation;
import net.webmo.symmetry.util.Matrix4D;
import net.webmo.symmetry.util.Point3D;

public class ImproperRotation
extends Rotation {
    private Matrix4D rotRefOp = new Matrix4D();

    public ImproperRotation(Point3D point, Point3D axis, int n) {
        super(point, axis, n);
    }

    public Point3D doOperation(Point3D before) {
        Point3D oldCoords = new Point3D(before);
        Point3D newCoords = new Point3D();
        oldCoords = oldCoords.sub(this.point);
        double a = this.axis.x / this.axis.length();
        double b = this.axis.y / this.axis.length();
        double c = this.axis.z / this.axis.length();
        double angle = Math.PI * 2 / (double)this.n;
        double cos = Math.cos(angle);
        double sin = Math.sin(angle);
        this.rotRefOp.identity();
        double[][] m = this.rotRefOp.matrix;
        m[0][0] = -(a * a) + b * b + c * c;
        m[0][1] = -2.0 * a * b;
        m[0][2] = -2.0 * a * c;
        m[1][0] = -2.0 * a * b;
        m[1][1] = a * a - b * b + c * c;
        m[1][2] = -2.0 * b * c;
        m[2][0] = -2.0 * a * c;
        m[2][1] = -2.0 * b * c;
        m[2][2] = a * a + b * b - c * c;
        newCoords.x = m[0][0] * oldCoords.x + m[0][1] * oldCoords.y + m[0][2] * oldCoords.z;
        newCoords.y = m[1][0] * oldCoords.x + m[1][1] * oldCoords.y + m[1][2] * oldCoords.z;
        newCoords.z = m[2][0] * oldCoords.x + m[2][1] * oldCoords.y + m[2][2] * oldCoords.z;
        m[0][0] = cos + (1.0 - cos) * this.axis.x * this.axis.x;
        m[0][1] = (1.0 - cos) * this.axis.x * this.axis.y - sin * this.axis.z;
        m[0][2] = (1.0 - cos) * this.axis.x * this.axis.z + sin * this.axis.y;
        m[1][0] = (1.0 - cos) * this.axis.x * this.axis.y + sin * this.axis.z;
        m[1][1] = cos + (1.0 - cos) * this.axis.y * this.axis.y;
        m[1][2] = (1.0 - cos) * this.axis.z * this.axis.y - sin * this.axis.x;
        m[2][0] = (1.0 - cos) * this.axis.x * this.axis.z - sin * this.axis.y;
        m[2][1] = (1.0 - cos) * this.axis.y * this.axis.z + sin * this.axis.x;
        m[2][2] = cos + (1.0 - cos) * this.axis.z * this.axis.z;
        Point3D finalCoords = new Point3D();
        finalCoords.x = m[0][0] * newCoords.x + m[0][1] * newCoords.y + m[0][2] * newCoords.z;
        finalCoords.y = m[1][0] * newCoords.x + m[1][1] * newCoords.y + m[1][2] * newCoords.z;
        finalCoords.z = m[2][0] * newCoords.x + m[2][1] * newCoords.y + m[2][2] * newCoords.z;
        finalCoords = finalCoords.add(this.point);
        return finalCoords;
    }

    public int getNumUniqueOperations() {
        int degree = 1;
        if (this.n % 2 == 1) {
            int i = 2;
            while (i < this.n * 2) {
                if (i != this.n && i % 2 != 0) {
                    ++degree;
                }
                ++i;
            }
        } else {
            int i = 2;
            while (i < this.n) {
                if (i % 2 == 1 && this.n / 2 != i) {
                    ++degree;
                }
                ++i;
            }
        }
        return degree;
    }

    public String getName() {
        return "S" + this.n;
    }

    public boolean equals(Object other) {
        if (super.equals(other)) {
            if (other instanceof ImproperRotation) {
                ImproperRotation otherRot = (ImproperRotation)other;
                return this.eqPoint(this.point, otherRot.point) && this.eqAxes(this.axis, otherRot.axis) && this.n == otherRot.n;
            }
            return false;
        }
        return false;
    }
}

