/*
 * Decompiled with CFR 0.152.
 */
package net.webmo.symmetry.elements;

import net.webmo.symmetry.molecule.Atom;
import net.webmo.symmetry.util.Point3D;

public abstract class Element {
    public static final double ERROR = 0.2;
    protected double distance;

    public abstract Point3D doOperation(Point3D var1);

    public Atom doOperation(Atom before) {
        Atom after = new Atom(before);
        after.setPosition(this.doOperation(before.getPosition()));
        return after;
    }

    public void setDistance(double distance) {
        this.distance = distance;
    }

    public double getDistance() {
        return this.distance;
    }

    public abstract int getNumUniqueOperations();

    public abstract String getName();

    public abstract int getDegree();

    public boolean equals(Object other) {
        if (other instanceof Element) {
            return ((Element)other).getName().equals(this.getName());
        }
        return false;
    }

    protected boolean eqPoint(Point3D comp1, Point3D comp2) {
        return this.eq(comp1.x, comp2.x) && this.eq(comp1.y, comp2.y) && this.eq(comp1.z, comp2.z);
    }

    protected boolean eqAxes(Point3D comp1, Point3D comp2) {
        return 1.0 - Math.abs(comp1.dotProd(comp2)) < 0.03473;
    }

    protected boolean eq(double comp1, double comp2) {
        return Math.abs(comp1 - comp2) < 0.2;
    }
}

