/*
 * Decompiled with CFR 0.152.
 */
package net.webmo.symmetry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import net.webmo.symmetry.Main;
import net.webmo.symmetry.PointGroup;
import net.webmo.symmetry.elements.Element;
import net.webmo.symmetry.elements.ImproperRotation;
import net.webmo.symmetry.elements.Inversion;
import net.webmo.symmetry.elements.ProperRotation;
import net.webmo.symmetry.elements.Reflection;
import net.webmo.symmetry.elements.Rotation;
import net.webmo.symmetry.molecule.Atom;
import net.webmo.symmetry.molecule.Molecule;
import net.webmo.symmetry.util.Matrix4D;
import net.webmo.symmetry.util.Point3D;
import net.webmo.symmetry.util.Profiler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Symmetry {
    private static Profiler profiler;
    public static final double GAUSSIAN_SYMMETRY_TOLERANCE = 1.0E-6;
    public static final int MAX_DEGREE = 6;
    private static final double DEFAULT_TOLERANCE = 0.1;
    private static final double MOMENT_TOLERANCE = 0.1;
    public static final double DOT_TOLERANCE = 0.03473;
    private static final double TRIANGLE_APOTHEM = 0.3333333333;
    private ArrayList<Element> elements;
    private ArrayList<PointGroup> pointGroups;
    private ArrayList<Atom> atoms;
    private ArrayList<ProperRotation> rotations;
    private ProperRotation primaryAxis;
    private String name = "";
    private double tolerance;
    private Point3D centerOfMass;
    private Point3D[] principalAxes;
    private double[] principalMoments;
    private int degeneracy;

    public Symmetry(List<Atom> atoms, String name) {
        this(atoms, name, 0.1);
    }

    public Symmetry(List<Atom> atoms, String name, double tolerance) {
        this(atoms, tolerance);
        this.name = name;
        profiler = new Profiler();
        long startTime = System.currentTimeMillis();
        boolean quick = false;
        if (quick) {
            System.out.format("Finding Point Group for %s:%n%n", name);
            System.out.println(String.valueOf(this.findSinglePointGroup()) + "\n");
        } else {
            System.out.println("---------------------------------------------------------");
            System.out.println(String.valueOf(this.name) + "     Tolerance: " + this.tolerance);
            System.out.println("---------------------------------------------------------");
            this.findSymmetryElements();
            this.findPointGroups();
        }
        long elapsedTime = System.currentTimeMillis() - startTime;
        System.out.format("Search took %f seconds%n", Float.valueOf((float)elapsedTime / 1000.0f));
        System.out.println();
        profiler.getLongestProfiles(5);
        System.out.println("\n");
    }

    public Symmetry(Molecule molecule, double tolerance) {
        this(molecule.getAtoms(), tolerance);
    }

    public Symmetry(List<Atom> atoms, double tolerance) {
        this.atoms = new ArrayList<Atom>(atoms);
        this.tolerance = tolerance;
        profiler = new Profiler();
    }

    public String guessPointGroup() {
        String guess = this.findSinglePointGroup();
        double totalError = 0.0;
        for (Element e : this.elements) {
            totalError += e.getDistance();
        }
        if ((totalError /= (double)this.elements.size()) > 1.0E-6) {
            guess = "*" + guess;
        }
        return guess;
    }

    public ArrayList<PointGroup> findAllPointGroups() {
        if (this.atoms.size() < 2) {
            return new ArrayList<PointGroup>();
        }
        this.findSymmetryElements();
        profiler.startTiming("Point Groups:");
        this.findPointGroups();
        profiler.stopTiming("Point Groups:");
        return this.pointGroups;
    }

    private void findSymmetryElements() {
        this.elements = new ArrayList();
        this.principalMoments = new double[3];
        this.principalAxes = new Point3D[3];
        Matrix4D tempPrincipalAxes = new Matrix4D();
        boolean isLinear = false;
        this.centerOfMass = this.findCenterOfMass(this.atoms);
        this.findPrincipalAxes(this.atoms, this.principalMoments, tempPrincipalAxes);
        int i = 0;
        while (i < 3) {
            this.principalAxes[i] = new Point3D(tempPrincipalAxes.matrix[0][i], tempPrincipalAxes.matrix[1][i], tempPrincipalAxes.matrix[2][i]);
            ++i;
        }
        this.degeneracy = 1;
        double minMoment = Math.min(this.principalMoments[0], Math.min(this.principalMoments[1], this.principalMoments[2]));
        double maxMoment = Math.max(this.principalMoments[0], Math.max(this.principalMoments[1], this.principalMoments[2]));
        double momentDiff = (maxMoment - minMoment) / maxMoment;
        if (momentDiff < 0.1) {
            this.degeneracy = 3;
        } else if (Math.abs(this.principalMoments[0] - this.principalMoments[1]) / maxMoment < 0.1 || Math.abs(this.principalMoments[1] - this.principalMoments[2]) / maxMoment < 0.1 || Math.abs(this.principalMoments[0] - this.principalMoments[2]) / maxMoment < 0.1) {
            this.degeneracy = 2;
            if (minMoment < 0.1) {
                int minPos = this.principalMoments[1] == minMoment ? 1 : (this.principalMoments[2] == minMoment ? 2 : 0);
                ProperRotation infRot = new ProperRotation(this.centerOfMass, this.principalAxes[minPos], -1);
                double distance = 0.0;
                for (Atom atom : this.atoms) {
                    distance += atom.getPosition().distance(Point3D.closestPointOnAxis(atom.getPosition(), infRot.getPoint(), infRot.getAxis()));
                }
                infRot.setDistance(distance /= (double)this.atoms.size());
                this.elements.add(infRot);
                isLinear = true;
            }
        }
        if (Main.outputLevel >= 0) {
            System.out.print("Principal Axes are ");
            switch (this.degeneracy) {
                case 1: {
                    System.out.print("non-");
                    break;
                }
                case 2: {
                    System.out.print("doubly ");
                    break;
                }
                case 3: {
                    System.out.print("triply ");
                }
            }
            System.out.println("degenerate");
        }
        this.rotations = new ArrayList();
        profiler.startTiming("Inversion:");
        this.findInversionCenter();
        profiler.stopTiming("Inversion:");
        if (!isLinear) {
            profiler.startTiming("Proper Rotations:");
            this.findProperRotationAxes();
            profiler.stopTiming("Proper Rotations:");
            profiler.startTiming("Improper Rotations:");
            this.findImproperRotationAxes();
            profiler.stopTiming("Improper Rotations:");
            profiler.startTiming("Reflections:");
            this.findReflectionPlanes();
            profiler.stopTiming("Reflections:");
        }
        if (Main.outputLevel >= 1) {
            this.printElementResults();
        }
    }

    private Point3D findCenterOfMass(Collection<Atom> atoms) {
        double totalMass = 0.0;
        double comX = 0.0;
        double comY = 0.0;
        double comZ = 0.0;
        for (Atom a : atoms) {
            comX += a.getPosition().x * a.getMass();
            comY += a.getPosition().y * a.getMass();
            comZ += a.getPosition().z * a.getMass();
            totalMass += a.getMass();
        }
        return new Point3D(comX / totalMass, comY / totalMass, comZ / totalMass);
    }

    private void findInversionCenter() {
        if (Main.outputLevel >= 2) {
            System.out.format("%n%n + Looking for inversion centers...%n", new Object[0]);
        }
        Inversion inv = new Inversion(this.centerOfMass);
        this.testSymmetryElement(inv);
        if (this.addElement(inv) && Main.outputLevel >= 2) {
            System.out.format("%n%s FOUND at %s with a rating of %f", inv.getName(), inv.getPosition().toString(), inv.getDistance());
        }
    }

    private void findPrincipalAxes(Collection<Atom> atoms, double[] momentsOutput, Matrix4D axesOutput) {
        double Ixx = 0.0;
        double Iyy = 0.0;
        double Izz = 0.0;
        double Ixy = 0.0;
        double Izx = 0.0;
        double Iyz = 0.0;
        Matrix4D inertialTensor = new Matrix4D();
        inertialTensor.identity();
        for (Atom atom : atoms) {
            Point3D a = atom.getPosition();
            double m = atom.getMass();
            Ixx += m * (Math.pow(a.y - this.centerOfMass.y, 2.0) + Math.pow(a.z - this.centerOfMass.z, 2.0));
            Iyy += m * (Math.pow(a.z - this.centerOfMass.z, 2.0) + Math.pow(a.x - this.centerOfMass.x, 2.0));
            Izz += m * (Math.pow(a.x - this.centerOfMass.x, 2.0) + Math.pow(a.y - this.centerOfMass.y, 2.0));
            Ixy -= m * (a.x - this.centerOfMass.x) * (a.y - this.centerOfMass.y);
            Izx -= m * (a.z - this.centerOfMass.z) * (a.x - this.centerOfMass.x);
            Iyz -= m * (a.y - this.centerOfMass.y) * (a.z - this.centerOfMass.z);
        }
        inertialTensor.matrix[0][0] = Ixx;
        inertialTensor.matrix[1][1] = Iyy;
        inertialTensor.matrix[2][2] = Izz;
        double d = Ixy;
        inertialTensor.matrix[2][1] = d;
        inertialTensor.matrix[0][1] = d;
        double d2 = Izx;
        inertialTensor.matrix[3][1] = d2;
        inertialTensor.matrix[0][2] = d2;
        double d3 = Iyz;
        inertialTensor.matrix[3][2] = d3;
        inertialTensor.matrix[1][2] = d3;
        inertialTensor.diag(momentsOutput, axesOutput);
    }

    private void findProperRotationAxes() {
        this.rotations = new ArrayList();
        this.getPrincipalAxisRotations();
        this.getAtomRotations();
        this.getMidpointRotations();
        if (this.degeneracy == 3) {
            this.getFaceRotations();
        }
        if (this.degeneracy != 3) {
            if (this.primaryAxis == null) {
                for (Element elem : this.elements) {
                    ProperRotation rot = (ProperRotation)elem;
                    if (this.primaryAxis != null && rot.getDegree() <= this.primaryAxis.getDegree()) continue;
                    this.primaryAxis = rot;
                }
            }
        } else {
            this.primaryAxis = null;
        }
    }

    private void getPrincipalAxisRotations() {
        int i = 0;
        while (i < 3) {
            Point3D pAxis = this.principalAxes[i];
            int n = 2;
            while (n <= 6) {
                ProperRotation rot = new ProperRotation(this.centerOfMass, pAxis, n);
                this.testSymmetryElement(rot);
                if (this.addElement(rot)) {
                    if (Main.outputLevel >= 2) {
                        System.out.format("%n%s FOUND in the direction of %s with a rating of %f", rot.getName(), rot.getAxis().toString(), rot.getDistance());
                    }
                    if (this.primaryAxis == null || rot.getDegree() > this.primaryAxis.getDegree()) {
                        this.primaryAxis = rot;
                    }
                    this.rotations.add(rot);
                }
                ++n;
            }
            this.rotations.add(new ProperRotation(this.centerOfMass, pAxis, 1));
            ++i;
        }
    }

    private void getAtomRotations() {
        for (Atom atom : this.atoms) {
            Point3D axis = atom.getPosition().sub(this.centerOfMass);
            if (!this.isInertiallyAllowed(axis)) continue;
            int n = 2;
            while (n <= 6) {
                ProperRotation rot = new ProperRotation(this.centerOfMass, axis, n);
                this.testSymmetryElement(rot);
                if (this.addElement(rot)) {
                    if (Main.outputLevel >= 2) {
                        System.out.format("%n%s FOUND in the direction of %s with a rating of %f", rot.getName(), rot.getAxis().toString(), rot.getDistance());
                    }
                    if (this.rotations.contains(rot)) {
                        this.rotations.set(this.rotations.indexOf(rot), rot);
                    } else {
                        this.rotations.add(rot);
                    }
                }
                ++n;
            }
        }
    }

    private void getMidpointRotations() {
        int f = 0;
        while (f < this.atoms.size() - 1) {
            int t = f + 1;
            while (t < this.atoms.size()) {
                Atom from = this.atoms.get(f);
                Atom to = this.atoms.get(t);
                if (to.getNumber() == from.getNumber() && (this.degeneracy != 3 || to.distance(from) < 5.0)) {
                    Point3D midPoint = to.getPosition().add(from.getPosition());
                    Point3D midAxis = (midPoint = midPoint.mult(0.5)).sub(this.centerOfMass);
                    if (this.isInertiallyAllowed(midAxis)) {
                        int n = 2;
                        while (n <= 6) {
                            ProperRotation rot = new ProperRotation(this.centerOfMass, midAxis, n);
                            this.testSymmetryElement(rot);
                            if (this.addElement(rot)) {
                                if (Main.outputLevel >= 2) {
                                    System.out.format("%n%s FOUND in the direction of %s with a rating of %f", rot.getName(), rot.getAxis().toString(), rot.getDistance());
                                }
                                if (this.rotations.contains(rot)) {
                                    this.rotations.set(this.rotations.indexOf(rot), rot);
                                } else {
                                    this.rotations.add(rot);
                                }
                            }
                            n += 2;
                        }
                    }
                }
                ++t;
            }
            ++f;
        }
    }

    private void getFaceRotations() {
        int[] n = new int[]{3, 5};
        ArrayList<ProperRotation> c2s = new ArrayList<ProperRotation>();
        for (ProperRotation rot : this.rotations) {
            if (rot.getDegree() != 2) continue;
            c2s.add(rot);
        }
        if (c2s.size() == 3) {
            int i = 0;
            while (i < c2s.size() - 1) {
                int j = i;
                while (j < c2s.size()) {
                    int factor = -1;
                    while (factor < 2) {
                        Point3D midpoint = ((ProperRotation)c2s.get(i)).getAxis().add(((ProperRotation)c2s.get(j)).getAxis());
                        midpoint = midpoint.mult(0.5 * (double)factor);
                        int k = 0;
                        while (k < c2s.size()) {
                            Point3D distVector = midpoint.sub(((ProperRotation)c2s.get(k)).getAxis());
                            Point3D midAxis = midpoint.sub(distVector.mult(0.3333333333));
                            ProperRotation rot = new ProperRotation(this.centerOfMass, midAxis, 3);
                            this.testSymmetryElement(rot);
                            if (this.addElement(rot)) {
                                if (Main.outputLevel >= 2) {
                                    System.out.format("%n%s FOUND in the direction of %s with a rating of %f", rot.getName(), rot.getAxis().toString(), rot.getDistance());
                                }
                                if (this.rotations.contains(rot)) {
                                    this.rotations.set(this.rotations.indexOf(rot), rot);
                                } else {
                                    this.rotations.add(rot);
                                }
                            }
                            ++k;
                        }
                        factor += 2;
                    }
                    ++j;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < c2s.size() - 1) {
                int j = i;
                while (j < c2s.size()) {
                    Point3D rot1 = ((ProperRotation)c2s.get(i)).getAxis();
                    Point3D rot2 = ((ProperRotation)c2s.get(j)).getAxis();
                    int polygon = 0;
                    while (polygon < n.length) {
                        ProperRotation faceRot = new ProperRotation(this.centerOfMass, rot1.crossProd(rot2), n[polygon]);
                        this.testSymmetryElement(faceRot);
                        if (this.addElement(faceRot)) {
                            if (Main.outputLevel >= 2) {
                                System.out.format("%n%s FOUND in the direction of %s with a rating of %f", faceRot.getName(), faceRot.getAxis().toString(), faceRot.getDistance());
                            }
                            if (this.rotations.contains(faceRot)) {
                                this.rotations.set(this.rotations.indexOf(faceRot), faceRot);
                            } else {
                                this.rotations.add(faceRot);
                            }
                        }
                        ++polygon;
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    private void findImproperRotationAxes() {
        if (Main.outputLevel >= 2) {
            System.out.format("%n%n + Looking for improper rotation axes...%n", new Object[0]);
        }
        for (Rotation rotation : this.rotations) {
            int n = 1;
            while (n <= 2) {
                int degree = rotation.getDegree() * n;
                if (degree > 2) {
                    ImproperRotation impRot = new ImproperRotation(rotation.getPoint(), rotation.getAxis(), degree);
                    this.testSymmetryElement(impRot);
                    if (this.addElement(impRot) && Main.outputLevel >= 2) {
                        System.out.format("%n%s FOUND in the direction of %s with a rating of %f", impRot.getName(), impRot.getAxis().toString(), impRot.getDistance());
                    }
                }
                ++n;
            }
        }
    }

    private void findReflectionPlanes() {
        boolean isTetrahedral = true;
        if (this.degeneracy == 3) {
            for (Element elem : this.elements) {
                if (!elem.getName().contains("S6")) continue;
                isTetrahedral = false;
                break;
            }
            if (!isTetrahedral) {
                int r = 0;
                while (r < this.rotations.size()) {
                    if (this.rotations.get(r).getDegree() != 2) {
                        this.rotations.remove(r);
                        --r;
                    }
                    ++r;
                }
            }
        }
        this.getRotationNormals();
        if (this.degeneracy != 3 || isTetrahedral) {
            this.getMidpointNormals();
        }
    }

    private void getRotationNormals() {
        for (ProperRotation axis : this.rotations) {
            Reflection ref = new Reflection(axis.getPoint(), axis.getAxis());
            this.testSymmetryElement(ref);
            if (!this.addElement(ref) || Main.outputLevel < 2) continue;
            System.out.format("%n%s FOUND with normal pointing %s with a rating of %f", ref.getName(), ref.getNormal().toString(), ref.getDistance());
        }
    }

    private void getMidpointNormals() {
        int f = 0;
        while (f < this.atoms.size() - 1) {
            Atom from = this.atoms.get(f);
            Point3D fromp = from.getPosition().sub(this.centerOfMass);
            int t = f + 1;
            while (t < this.atoms.size()) {
                Atom to = this.atoms.get(t);
                Point3D top = to.getPosition().sub(this.centerOfMass);
                if (to.getNumber() == from.getNumber() && (this.degeneracy != 3 || to.distance(from) < 5.0)) {
                    Point3D midPoint = top.add(fromp);
                    midPoint = midPoint.mult(0.5);
                    Point3D axis = fromp.crossProd(top);
                    Point3D crossProd = axis.crossProd(midPoint);
                    if (this.isInertiallyAllowed(crossProd) && crossProd.length() > 0.001) {
                        Reflection ref = new Reflection(this.centerOfMass, crossProd);
                        this.testSymmetryElement(ref);
                        if (this.addElement(ref) && Main.outputLevel >= 2) {
                            System.out.format("%n%s FOUND with normal pointing (%f,%f,%f) with a rating of %f", ref.getName(), ref.getNormal().x, ref.getNormal().y, ref.getNormal().z, ref.getDistance());
                        }
                    }
                }
                ++t;
            }
            ++f;
        }
    }

    private String findSinglePointGroup() {
        String pointGroupGuess;
        block36: {
            Rotation primaryAxis;
            double GUESS_TOLERANCE;
            block34: {
                block35: {
                    this.tolerance = GUESS_TOLERANCE = 0.1;
                    pointGroupGuess = "C1";
                    this.elements = new ArrayList();
                    this.principalMoments = new double[3];
                    Matrix4D tempPrincipalAxes = new Matrix4D();
                    this.principalAxes = new Point3D[3];
                    if (this.atoms.size() == 1) {
                        return "R3";
                    }
                    this.centerOfMass = this.findCenterOfMass(this.atoms);
                    this.findPrincipalAxes(this.atoms, this.principalMoments, tempPrincipalAxes);
                    double minMoment = Math.min(this.principalMoments[0], Math.min(this.principalMoments[1], this.principalMoments[2]));
                    double maxMoment = Math.max(this.principalMoments[0], Math.max(this.principalMoments[1], this.principalMoments[2]));
                    double momentDiff = (maxMoment - minMoment) / maxMoment;
                    if (minMoment < 0.1) {
                        int index = 0;
                        if (this.principalMoments[1] == minMoment) {
                            index = 1;
                        } else if (this.principalMoments[2] == minMoment) {
                            index = 2;
                        }
                        Point3D refAxis = new Point3D(tempPrincipalAxes.matrix[0][index], tempPrincipalAxes.matrix[1][index], tempPrincipalAxes.matrix[2][index]);
                        Reflection ref = new Reflection(this.centerOfMass, refAxis);
                        this.testSymmetryElement(ref);
                        if (this.addElement(ref)) {
                            return "D\u221ed";
                        }
                        return "C\u221ev";
                    }
                    if (momentDiff < 0.1) {
                        return "cubic";
                    }
                    primaryAxis = null;
                    int i = 0;
                    while (i < 3) {
                        Point3D pAxis;
                        this.principalAxes[i] = pAxis = new Point3D(tempPrincipalAxes.matrix[0][i], tempPrincipalAxes.matrix[1][i], tempPrincipalAxes.matrix[2][i]);
                        int n = 2;
                        while (n <= 6) {
                            ProperRotation rot = new ProperRotation(this.centerOfMass, pAxis, n);
                            this.testSymmetryElement(rot);
                            if (this.addElement(rot) && (primaryAxis == null || rot.getDegree() > primaryAxis.getDegree())) {
                                primaryAxis = rot;
                            }
                            ++n;
                        }
                        Reflection ref = new Reflection(this.centerOfMass, pAxis);
                        this.testSymmetryElement(ref);
                        this.addElement(ref);
                        ++i;
                    }
                    if (primaryAxis != null) break block34;
                    if (this.elements.size() != 1) break block35;
                    if (this.elements.get(0) instanceof Reflection) {
                        return "Cs";
                    }
                    break block36;
                }
                if (this.elements.size() != 0) break block36;
                Inversion inv = new Inversion(this.centerOfMass);
                this.testSymmetryElement(inv);
                if (this.addElement(inv)) {
                    return "Ci";
                }
                break block36;
            }
            if (primaryAxis != null) {
                int j = 0;
                while (j < this.elements.size()) {
                    if (this.elements.get(j) instanceof ProperRotation) {
                        ProperRotation rot = (ProperRotation)this.elements.get(j);
                        if (!rot.getAxis().equals(primaryAxis.getAxis())) {
                            this.elements.remove(rot);
                            --j;
                        }
                    } else {
                        this.elements.remove(j);
                        --j;
                    }
                    ++j;
                }
                int perpAxes = 0;
                int perpPlanes = 0;
                int f = 0;
                while (f < this.atoms.size()) {
                    Atom from = this.atoms.get(f);
                    Point3D atomAxis = from.getPosition().sub(this.centerOfMass);
                    double dotprod = atomAxis.dotProd(primaryAxis.getAxis());
                    if (Math.abs(dotprod) < GUESS_TOLERANCE) {
                        ProperRotation rot = new ProperRotation(this.centerOfMass, atomAxis, 2);
                        this.testSymmetryElement(rot);
                        int size = this.elements.size();
                        if (this.addElement(rot) && size != this.elements.size()) {
                            ++perpAxes;
                        }
                    }
                    Point3D orthogAxis = atomAxis.crossProd(primaryAxis.getAxis());
                    Reflection ref = new Reflection(this.centerOfMass, orthogAxis);
                    this.testSymmetryElement(ref);
                    int size = this.elements.size();
                    if (this.addElement(ref) && size != this.elements.size()) {
                        ++perpPlanes;
                    }
                    int t = f + 1;
                    while (t < this.atoms.size()) {
                        Atom to = this.atoms.get(t);
                        if (to.getNumber() == from.getNumber()) {
                            Point3D midPoint = to.getPosition().add(from.getPosition());
                            Point3D midAxis = (midPoint = midPoint.mult(0.5)).sub(this.centerOfMass);
                            dotprod = midAxis.dotProd(primaryAxis.getAxis());
                            if (Math.abs(dotprod) < GUESS_TOLERANCE) {
                                ProperRotation rot = new ProperRotation(this.centerOfMass, midAxis, 2);
                                this.testSymmetryElement(rot);
                                size = this.elements.size();
                                if (this.addElement(rot) && size != this.elements.size()) {
                                    ++perpAxes;
                                }
                            }
                            orthogAxis = midAxis.crossProd(primaryAxis.getAxis());
                            ref = new Reflection(this.centerOfMass, orthogAxis);
                            this.testSymmetryElement(ref);
                            size = this.elements.size();
                            if (this.addElement(ref) && size != this.elements.size()) {
                                ++perpPlanes;
                            }
                        }
                        ++t;
                    }
                    ++f;
                }
                int i = 0;
                while (i < 3) {
                    Point3D refAxis = primaryAxis.getAxis().crossProd(this.principalAxes[i]);
                    Reflection ref = new Reflection(this.centerOfMass, refAxis);
                    this.testSymmetryElement(ref);
                    int size = this.elements.size();
                    if (this.addElement(ref) && size != this.elements.size()) {
                        ++perpPlanes;
                    }
                    ++i;
                }
                pointGroupGuess = perpAxes == primaryAxis.getDegree() ? "D" + primaryAxis.getDegree() : "C" + primaryAxis.getDegree();
                Reflection ref = new Reflection(this.centerOfMass, primaryAxis.getAxis());
                this.testSymmetryElement(ref);
                if (this.addElement(ref)) {
                    return String.valueOf(pointGroupGuess) + "h";
                }
                if (perpPlanes == primaryAxis.getDegree()) {
                    if (pointGroupGuess.contains("D")) {
                        return String.valueOf(pointGroupGuess) + "d";
                    }
                    return String.valueOf(pointGroupGuess) + "v";
                }
                if (perpPlanes == 0) {
                    int n = 4;
                    while (n < 10) {
                        ImproperRotation imp = new ImproperRotation(this.centerOfMass, primaryAxis.getAxis(), n);
                        this.testSymmetryElement(imp);
                        if (this.addElement(imp)) {
                            return "S" + imp.getDegree();
                        }
                        n += 2;
                    }
                }
            }
        }
        return pointGroupGuess;
    }

    private void findPointGroups() {
        this.pointGroups = new ArrayList();
        PointGroup.PointGroups[] pointGroupsArray = PointGroup.PointGroups.values();
        int n = pointGroupsArray.length;
        int n2 = 0;
        while (n2 < n) {
            PointGroup.PointGroups testGrp = pointGroupsArray[n2];
            ArrayList<Element> foundElements = new ArrayList<Element>(this.elements);
            ArrayList<Element> finalElements = new ArrayList<Element>();
            int missingElements = 0;
            int extraElements = 0;
            int totalOperations = 0;
            ProperRotation groupPrimaryAxis = this.primaryAxis;
            boolean groupPrimaryAxisSet = false;
            if (testGrp.isCubic()) {
                groupPrimaryAxis = null;
                groupPrimaryAxisSet = true;
            }
            for (PointGroup.PointGroups.Operation testOp : testGrp.getOperations()) {
                boolean moreElements = true;
                int count = 1;
                int num = testOp.getNumber();
                boolean coincidentWithPrimary = true;
                while (count <= num && moreElements) {
                    Element bestElement = null;
                    moreElements = false;
                    int i = 0;
                    while (i < foundElements.size()) {
                        Element checkElement = foundElements.get(i);
                        if (checkElement.getName().equals(testOp.getElementType()) && (bestElement == null || checkElement.getDistance() < bestElement.getDistance())) {
                            if (groupPrimaryAxis != null) {
                                Point3D checkAxis = null;
                                if (checkElement instanceof Rotation) {
                                    checkAxis = ((Rotation)checkElement).getAxis();
                                } else if (checkElement instanceof Reflection) {
                                    checkAxis = ((Reflection)checkElement).getNormal();
                                }
                                if (checkAxis != null) {
                                    if (coincidentWithPrimary) {
                                        if (1.0 - Math.abs(checkAxis.dotProd(groupPrimaryAxis.getAxis())) < 0.03473) {
                                            bestElement = checkElement;
                                        }
                                    } else if (Math.abs(checkAxis.dotProd(groupPrimaryAxis.getAxis())) < 0.03473) {
                                        bestElement = checkElement;
                                    }
                                } else {
                                    bestElement = checkElement;
                                }
                            } else {
                                bestElement = checkElement;
                            }
                        }
                        ++i;
                    }
                    if (bestElement != null) {
                        if (bestElement instanceof ProperRotation && !groupPrimaryAxisSet) {
                            groupPrimaryAxis = (ProperRotation)bestElement;
                            groupPrimaryAxisSet = true;
                        }
                        foundElements.remove(bestElement);
                        finalElements.add(bestElement);
                        count += bestElement.getNumUniqueOperations();
                        totalOperations += bestElement.getNumUniqueOperations();
                        moreElements = true;
                    } else if (coincidentWithPrimary) {
                        coincidentWithPrimary = false;
                        moreElements = true;
                    }
                    if (moreElements) continue;
                    missingElements += num - count + 1;
                }
            }
            for (Element extraElem : foundElements) {
                extraElements += extraElem.getNumUniqueOperations();
            }
            PointGroup ptGrp = new PointGroup(finalElements, this.atoms, testGrp);
            double ptGrpDistance = 0.0;
            for (Element el : finalElements) {
                ptGrpDistance += el.getDistance();
            }
            ptGrp.setDistance(ptGrpDistance / (double)(finalElements.size() == 0 ? 1 : finalElements.size()));
            ptGrp.setNumExtraElements(extraElements);
            ptGrp.setNumMissingElements(missingElements);
            if (missingElements == 0) {
                int index = 0;
                int i = 0;
                while (i < this.pointGroups.size()) {
                    if (extraElements > this.pointGroups.get(i).getNumExtraElements()) {
                        ++index;
                    } else {
                        if (extraElements != this.pointGroups.get(i).getNumExtraElements()) break;
                        if (ptGrp.getDistance() > this.pointGroups.get(i).getDistance()) {
                            ++index;
                        }
                    }
                    ++i;
                }
                this.pointGroups.add(index, ptGrp);
            }
            ++n2;
        }
        if (Main.outputLevel >= 0) {
            this.printPointGroupResults();
        }
    }

    private boolean isInertiallyAllowed(Point3D axis) {
        return this.isInertiallyAllowed(axis, this.principalAxes, this.degeneracy);
    }

    private boolean isInertiallyAllowed(Point3D point, Point3D[] eigenvectors, int degeneracy) {
        if (degeneracy == 3) {
            return true;
        }
        double[] dotproducts = new double[3];
        double maxDotprod = 0.0;
        double minDotprod = 1.0;
        Point3D checkPoint = new Point3D(point);
        checkPoint.unit();
        int i = 0;
        while (i < 3) {
            dotproducts[i] = Math.abs(checkPoint.dotProd(eigenvectors[i]));
            if (dotproducts[i] > maxDotprod) {
                maxDotprod = dotproducts[i];
            }
            if (dotproducts[i] < minDotprod) {
                minDotprod = dotproducts[i];
            }
            ++i;
        }
        if (Math.abs(minDotprod) < 0.03473) {
            if (degeneracy == 2) {
                return true;
            }
            if (Math.abs(1.0 - maxDotprod) < 0.03473) {
                return true;
            }
        }
        return false;
    }

    private double testSymmetryElement(Element elem) {
        double totalDist = 0.0;
        double subTotalDist = 0.0;
        int numOperations = 1;
        if (elem.getDegree() > 1) {
            numOperations = elem.getDegree() - 1;
        }
        int i = 0;
        while (i < numOperations) {
            for (Atom before : this.atoms) {
                Point3D closestPoint;
                Element the_elem;
                Atom after = elem.doOperation(before);
                Atom closestAtom = after.findClosestAtom(this.atoms);
                double shortestDist = after.distance(closestAtom);
                double dist = 1.0;
                if (elem instanceof Inversion) {
                    dist = closestAtom.getPosition().distance(this.centerOfMass);
                } else if (elem instanceof Reflection) {
                    the_elem = (Reflection)elem;
                    closestPoint = Point3D.closestPointInPlane(closestAtom.getPosition(), ((Reflection)the_elem).getPoint(), ((Reflection)the_elem).getNormal());
                    dist = closestAtom.getPosition().distance(closestPoint);
                } else if (elem instanceof Rotation) {
                    the_elem = (Rotation)elem;
                    closestPoint = Point3D.closestPointOnAxis(closestAtom.getPosition(), ((Rotation)the_elem).getPoint(), ((Rotation)the_elem).getAxis());
                    dist = closestAtom.getPosition().distance(closestPoint);
                }
                if (dist > 1.0) {
                    shortestDist /= dist;
                }
                subTotalDist = Math.max(subTotalDist, shortestDist);
            }
            if (subTotalDist > this.tolerance) {
                elem.setDistance(subTotalDist);
                return subTotalDist;
            }
            totalDist += subTotalDist;
            ++i;
        }
        elem.setDistance(totalDist /= (double)numOperations);
        return totalDist;
    }

    private boolean addElement(Element elem) {
        if (elem.getDistance() < this.tolerance) {
            boolean found = false;
            for (Element check : this.elements) {
                if (!elem.equals(check)) continue;
                found = true;
                if (!(elem.getDistance() < check.getDistance())) continue;
                this.elements.remove(check);
                return this.elements.add(elem);
            }
            if (!found) {
                return this.elements.add(elem);
            }
        }
        if (!this.elements.contains(elem) && elem.getDistance() < this.tolerance) {
            return this.elements.add(elem);
        }
        return false;
    }

    private void printElementResults() {
        if (this.elements.size() > 0) {
            System.out.println("\n\n + ELEMENTS FOUND:\n");
            for (Element elem : this.elements) {
                System.out.format("%s with a rating of %f%n", elem.getName(), elem.getDistance());
            }
        } else {
            System.out.println("\n\n --- NO ELEMENTS FOUND! --- \n");
        }
    }

    private void printPointGroupResults() {
        HashMap<String, Integer> ptGrpMap = new HashMap<String, Integer>();
        for (Element elem : this.elements) {
            int elemWeight = elem.getNumUniqueOperations();
            if (ptGrpMap.containsKey(elem.getName())) {
                ptGrpMap.put(elem.getName(), (Integer)ptGrpMap.get(elem.getName()) + elemWeight);
                continue;
            }
            ptGrpMap.put(elem.getName(), elemWeight);
        }
        System.out.format("%n + POINT GROUP FOUND:%n%n{ E", new Object[0]);
        for (String op : ptGrpMap.keySet()) {
            if ((Integer)ptGrpMap.get(op) > 1) {
                System.out.format(", %d%s", ptGrpMap.get(op), op);
                continue;
            }
            System.out.format(", %s", op);
        }
        System.out.println(" }\n");
        PointGroup finalGroup = this.pointGroups.get(0);
        String exact = "***************************";
        if (finalGroup.getNumExtraElements() == 0) {
            System.out.println(String.valueOf(exact) + "\n" + "1. " + finalGroup.getName() + ":  " + finalGroup.getDistance() + "\n" + exact);
        } else {
            System.out.println("1. " + finalGroup.getName() + ":  " + finalGroup.getDistance());
        }
        if (Main.outputLevel >= 1) {
            int i = 1;
            while (i < this.pointGroups.size()) {
                finalGroup = this.pointGroups.get(i);
                System.out.print(String.valueOf(i + 1) + ". " + finalGroup.getName() + ":  " + finalGroup.getDistance());
                if (Main.outputLevel == 2) {
                    System.out.println(" - " + finalGroup.getNumMissingElements() + " M, " + finalGroup.getNumExtraElements() + " E");
                } else {
                    System.out.println();
                }
                ++i;
            }
        }
        System.out.println();
    }

    public ArrayList<Element> getElements() {
        return this.elements;
    }

    public ArrayList<PointGroup> getPointGroups() {
        return this.pointGroups;
    }

    public ArrayList<Atom> getAtoms() {
        return this.atoms;
    }
}

