@echo off
rem *****************************************************************
rem * gamess.64_WG_DDE.bat   (Version 14)                           *
rem *                                                               *
rem *        Drag-and-Drop Execution Utility for Gamess(US)         *
rem *           after GAMESS VERSION = 30 SEP 2021 (R2 Patch 2)              *
rem *                                                               *
rem *     Up to 9 WinGamess jobs can be sequentially executed       *
rem *   simply by drag-and-drop of input file(s) on this bat file.  *
rem *                                                               *
rem * This batch utility is originally written by M. Suenaga, Ph.D. *
rem *     Department of Chemistry, Graduate School of Science,      *
rem *                   Kyushu University, Japan                    *
rem *****************************************************************


rem <----   Four DOS environment variables                         ---->
rem <----   ( WinGamess_Base, WinGamess_Version,                   ---->
rem <----     CPU and OverwriteExistingFiles )                     ---->
rem <----   should be set correctly according to your environment. ---->
rem <----   See below.                                             ---->

rem %%%%%  Environment  Variable 1  %%%%%

set WinGamess_Base=C:\gamess-64

rem #####################################################
rem ###                                               ###
rem ###    Specify the absolute path of a folder      ###
rem ###    that contains Gamess(US) executable file.  ###
rem ###                                               ###
rem ### DO NOT enclose it with double quotations.     ###
rem ### e.g.                                          ###
rem ### WinGamess_Base=C:\gamess.32      (correct)    ###
rem ### WinGamess_Base="C:\gamess.32"    (incorrect)  ###
rem ###                                               ###
rem #####################################################

rem %%%%%  Environment  Variable 2  %%%%%

set WinGamess_Version=2021.R2.P2.intel.msucc

rem ##################################################
rem ###                                            ###
rem ### Specify the WinGamess version number.      ###
rem ###                                            ###
rem ##################################################


rem %%%%%  Environment  Variable 3  %%%%%

set CPU=2

rem ###################################
rem ###                             ###
rem ### Specify the number of CPU.  ###
rem ###                             ###
rem ###################################


rem %%%%%  Environment  Variable 4  %%%%%

set OverwriteExistingFiles=yes

rem ##############################################################################
rem ###                                                                        ###
rem ### OverwriteExistingFiles=yes   (Disabling Overwrie Confirmation Prompt.) ###
rem ### OverwriteExistingFiles=no    (Enabling Overwrie Confirmation Prompt.)  ###
rem ###                                                                        ###
rem ###      This parameter is valid only for the second and later jobs.       ###
rem ###      For the 1st job, Overwrite Confirmation Prompt is always enabled. ###
rem ###                                                                        ###
rem ##############################################################################

if not exist %WinGamess_Base%\scr mkdir %WinGamess_Base%\scr
rem if not exist %WinGamess_Base%\temp mkdir %WinGamess_Base%\temp

rem *****************
rem *     JOB 1     *
rem *****************
echo *********************************************************************
echo    Drag-and-Drop Execution Utility (%~nx0 Ver.9) for WinGamess
echo       Up to 9 WinGamess jobs can be sequentially executed. 
echo *********************************************************************
echo.
echo    [ Job 1 ] :   %~nx1
echo.

if not exist "%WinGamess_Base%\gamess.%WinGamess_Version%.exe" goto no_gamess

if "%~1" == "" goto no_arg
if "%~x1" == "" goto no_ext
if not "%~x1" == ".inp" goto bad_ext


set m1=%~dp1
set m2=%~n1
set job=1

if exist "%m1%%m2%.out" goto output_exists

:continue_1

goto run_WinGamess

:end_1


rem *****************
rem *     JOB 2     *
rem *****************

if "%~2" == "" goto no_arg

echo *********************************************************************
echo.
echo    [ Job 2 ] :   %~nx2
echo.

if "%~x2" == "" goto no_ext
if not "%~x2" == ".inp" goto bad_ext

set m1=%~dp2
set m2=%~n2
set job=2

if "%OverwriteExistingFiles%" == "yes" goto continue_2
if exist "%m1%%m2%.out" goto output_exists

:continue_2

goto run_WinGamess

:end_2


rem *****************
rem *     JOB 3     *
rem *****************

if "%~3" == "" goto no_arg

echo *********************************************************************
echo.
echo    [ Job 3 ] :   %~nx3
echo.

if "%~x3" == "" goto no_ext
if not "%~x3" == ".inp" goto bad_ext

set m1=%~dp3
set m2=%~n3
set job=3

if "%OverwriteExistingFiles%" == "yes" goto continue_3
if exist "%m1%%m2%.out" goto output_exists

:continue_3

goto run_WinGamess

:end_3


rem *****************
rem *     JOB 4     *
rem *****************

if "%~4" == "" goto no_arg

echo *********************************************************************
echo.
echo    [ Job 4 ] :   %~nx4
echo.

if "%~x4" == "" goto no_ext
if not "%~x4" == ".inp" goto bad_ext

set m1=%~dp4
set m2=%~n4
set job=4

if "%OverwriteExistingFiles%" == "yes" goto continue_4
if exist "%m1%%m2%.out" goto output_exists

:continue_4

goto run_WinGamess

:end_4


rem *****************
rem *     JOB 5     *
rem *****************

if "%~5" == "" goto no_arg

echo *********************************************************************
echo.
echo    [ Job 5 ] :   %~nx5
echo.

if "%~x5" == "" goto no_ext
if not "%~x5" == ".inp" goto bad_ext

set m1=%~dp5
set m2=%~n5
set job=5

if "%OverwriteExistingFiles%" == "yes" goto continue_5
if exist "%m1%%m2%.out" goto output_exists

:continue_5

goto run_WinGamess

:end_5


rem *****************
rem *     JOB 6     *
rem *****************

if "%~6" == "" goto no_arg

echo *********************************************************************
echo.
echo    [ Job 6 ] :   %~nx6
echo.

if "%~x6" == "" goto no_ext
if not "%~x6" == ".inp" goto bad_ext

set m1=%~dp6
set m2=%~n6
set job=6

if "%OverwriteExistingFiles%" == "yes" goto continue_6
if exist "%m1%%m2%.out" goto output_exists

:continue_6

goto run_WinGamess

:end_6


rem *****************
rem *     JOB 7     *
rem *****************

if "%~7" == "" goto no_arg

echo *********************************************************************
echo.
echo    [ Job 7 ] :   %~nx7
echo.

if "%~x7" == "" goto no_ext
if not "%~x7" == ".inp" goto bad_ext

set m1=%~dp7
set m2=%~n7
set job=7

if "%OverwriteExistingFiles%" == "yes" goto continue_7
if exist "%m1%%m2%.out" goto output_exists

:continue_7

goto run_WinGamess

:end_7


rem *****************
rem *     JOB 8     *
rem *****************

if "%~8" == "" goto no_arg

echo *********************************************************************
echo.
echo    [ Job 8 ] :   %~nx8
echo.

if "%~x8" == "" goto no_ext
if not "%~x8" == ".inp" goto bad_ext

set m1=%~dp8
set m2=%~n8
set job=8

if "%OverwriteExistingFiles%" == "yes" goto continue_8
if exist "%m1%%m2%.out" goto output_exists

:continue_8

goto run_WinGamess

:end_8


rem *****************
rem *     JOB 9     *
rem *****************

if "%~9" == "" goto no_arg

echo *********************************************************************
echo.
echo    [ Job 9 ] :   %~nx9
echo.

if "%~x9" == "" goto no_ext
if not "%~x9" == ".inp" goto bad_ext

set m1=%~dp9
set m2=%~n9
set job=9

if "%OverwriteExistingFiles%" == "yes" goto continue_9
if exist "%m1%%m2%.out" goto output_exists

:continue_9

goto run_WinGamess

:end_9

rem ======= End of Job(s) ========

pause
exit

rem ################################################################

:run_WinGamess

del "%WinGamess_Base%\scr\%m2%.*"
del "%WinGamess_Base%\scratch\%m2%.*"
del "%WinGamess_Base%\temp\%m2%.*"
del "%WinGamess_Base%\tmp\%m2%.*"
rem  --- from Ver. 12 ---
del "%WinGamess_Base%\restart\%m2%.*"
rem  --------------------

cd /D "%WinGamess_Base%"

echo on

copy "%m1%%m2%.inp" "%m2%.inp"
rem call rungms.bat "%m2%.inp" %WinGamess_Version% %CPU% 0 "%m2%.out"
call rungms.bat %m2%.inp %WinGamess_Version%  %CPU%  %m2%.out

copy "%m2%.out" "%m1%%m2%.out"

if not "%WinGamess_Base%\" == "%m1%"  (del "%m2%.inp"  del "%m2%.out")

@echo off

echo Execution terminated
echo.

if "%job%" == "1" goto end_1
if "%job%" == "2" goto end_2
if "%job%" == "3" goto end_3
if "%job%" == "4" goto end_4
if "%job%" == "5" goto end_5
if "%job%" == "6" goto end_6
if "%job%" == "7" goto end_7
if "%job%" == "8" goto end_8
if "%job%" == "9" goto end_9

rem ################################################################

:output_exists

echo Output file "%m2%.out" already exists! 
set /P ans=Overwrite it?  (y/n) 

if "%ans%" == "y" goto :yes
if "%ans%" == "n" goto :no

:yes
if "%job%" == "1" goto continue_1
if "%job%" == "2" goto continue_2
if "%job%" == "3" goto continue_3
if "%job%" == "4" goto continue_4
if "%job%" == "5" goto continue_5
if "%job%" == "6" goto continue_6
if "%job%" == "7" goto continue_7
if "%job%" == "8" goto continue_8
if "%job%" == "9" goto continue_9

:no
echo Execution canceled
pause
goto $EOF

:no_arg
if "%~1" == "" echo ********************************************************
if "%~1" == "" echo   DO NOT double click %~nx0.
if "%~1" == "" echo.
if "%~1" == "" echo   To start WinGamess calculation,
if "%~1" == "" echo   just drag-and-drop input file(s) on %~nx0.
if "%~1" == "" echo ********************************************************
pause
goto $EOF

:no_ext
echo Invalid input file extension : NO EXTENSION
pause
goto $EOF

:bad_ext
echo Invalid input file extension
pause
goto $EOF

:no_gamess
echo --WARNING--  %WinGamess_Base%\gamess.%WinGamess_Version%.exe does not exist.
echo.
echo --Current Values--
echo WinGamess_Base=%WinGamess_Base%
echo WinGamess_Version=%WinGamess_Version%
echo.
echo Correct?
echo If not, specify WinGamess_Base and/or WinGamess_Version correctly.
echo.
echo.
echo Please note that WinGamess_Base should not be
echo enclosed with double quotation marks.
echo e.g.
echo WinGamess_Base=C:\WinGamess          (correct)
echo WinGamess_Base="C:\WinGamess"       (incorrect)
echo.
pause

