@echo off
rem *******************************************************************
rem *      Firefly_DDE.bat   (Version 7, released on Jul.22 2007)     *
rem *                                                                 *
rem *      Drag-and-Drop Execution Utility for Firefly (PC GAMESS)    *
rem *                                                                 *
rem *  Up to 9 Firefly (PC GAMESS) jobs can be sequentially executed  *
rem *   simply by drag-and-drop of input file(s) on Firefly_DDE.bat.  *
rem *                                                                 *
rem *  This batch utility is originally written by M. Suenaga, Ph.D.  *
rem *       Department of Chemistry, Graduate School of Sciences,     *
rem *                  Kyushu University, Japan                       *
rem *******************************************************************


rem <----   Three DOS environment variables                          ---->
rem <----   ( GAMESS_Base, GAMESS_Exe, and OverwriteExistingFiles )  ---->
rem <----   should be set correctly according to your environment.   ---->
rem <----   See below.                                               ---->


rem %%%%%  Environment  Variable 1  %%%%%

set GAMESS_Base=C:\ff820_windows

rem ############################################################
rem ###                                                      ###
rem ### Specify the absolute path of a folder                ###
rem ### that contains Firefly (PC GAMESS) executable file.   ###
rem ###                                                      ###
rem ### DO NOT enclose it with double quotations.            ###
rem ### e.g.                                                 ###
rem ### GAMESS_Base=C:\ff800      (correct)                  ###
rem ### GAMESS_Base="C:\ff800"    (incorrect)                ###
rem ###                                                      ###
rem ############################################################


rem %%%%%  Environment  Variable 2  %%%%%

set GAMESS_Exe=Firefly820.exe

rem ########################################################
rem ###                                                  ###
rem ### Specify the Firefly (PC GAMESS) executable file. ###
rem ###                                                  ###
rem ########################################################


rem %%%%%  Environment  Variable 3  %%%%%

set OverwriteExistingFiles=yes

rem ##############################################################################
rem ###                                                                        ###
rem ### OverwriteExistingFiles=yes   (Disabling Overwrie Confirmation Prompt.) ###
rem ### OverwriteExistingFiles=no    (Enabling Overwrie Confirmation Prompt.)  ###
rem ###                                                                        ###
rem ###      This parameter is valid only for the second and later jobs.       ###
rem ###      For the 1st job, Overwrite Confirmation Prompt is always enabled. ###
rem ###                                                                        ###
rem ##############################################################################


rem *****************
rem *     JOB 1     *
rem *****************
echo *******************************************************************************
echo    Drag-and-Drop Execution Utility (%~nx0 Ver.7) for Firefly (PC GAMESS)
echo       Up to 9 Firefly (PC GAMESS) jobs can be sequentially executed. 
echo *******************************************************************************
echo.
echo    [ Job 1 ] :   %~nx1
echo.

if not exist "%GAMESS_Base%\%GAMESS_Exe%" goto no_gamess

if "%~1" == "" goto no_arg
if "%~x1" == "" goto no_ext
if not "%~x1" == ".inp" goto bad_ext


set m1=%~dp1
set m2=%~n1
set job=1

if exist "%m1%%m2%.out" goto output_exists

:continue_1

goto run_PC_GAMESS

:end_1


rem *****************
rem *     JOB 2     *
rem *****************

if "%~2" == "" goto no_arg

echo *********************************************************************
echo.
echo    [ Job 2 ] :   %~nx2
echo.

if "%~x2" == "" goto no_ext
if not "%~x2" == ".inp" goto bad_ext

set m1=%~dp2
set m2=%~n2
set job=2

if "%OverwriteExistingFiles%" == "yes" goto continue_2
if exist "%m1%%m2%.out" goto output_exists

:continue_2

goto run_PC_GAMESS

:end_2


rem *****************
rem *     JOB 3     *
rem *****************

if "%~3" == "" goto no_arg

echo *********************************************************************
echo.
echo    [ Job 3 ] :   %~nx3
echo.

if "%~x3" == "" goto no_ext
if not "%~x3" == ".inp" goto bad_ext

set m1=%~dp3
set m2=%~n3
set job=3

if "%OverwriteExistingFiles%" == "yes" goto continue_3
if exist "%m1%%m2%.out" goto output_exists

:continue_3

goto run_PC_GAMESS

:end_3


rem *****************
rem *     JOB 4     *
rem *****************

if "%~4" == "" goto no_arg

echo *********************************************************************
echo.
echo    [ Job 4 ] :   %~nx4
echo.

if "%~x4" == "" goto no_ext
if not "%~x4" == ".inp" goto bad_ext

set m1=%~dp4
set m2=%~n4
set job=4

if "%OverwriteExistingFiles%" == "yes" goto continue_4
if exist "%m1%%m2%.out" goto output_exists

:continue_4

goto run_PC_GAMESS

:end_4


rem *****************
rem *     JOB 5     *
rem *****************

if "%~5" == "" goto no_arg

echo *********************************************************************
echo.
echo    [ Job 5 ] :   %~nx5
echo.

if "%~x5" == "" goto no_ext
if not "%~x5" == ".inp" goto bad_ext

set m1=%~dp5
set m2=%~n5
set job=5

if "%OverwriteExistingFiles%" == "yes" goto continue_5
if exist "%m1%%m2%.out" goto output_exists

:continue_5

goto run_PC_GAMESS

:end_5


rem *****************
rem *     JOB 6     *
rem *****************

if "%~6" == "" goto no_arg

echo *********************************************************************
echo.
echo    [ Job 6 ] :   %~nx6
echo.

if "%~x6" == "" goto no_ext
if not "%~x6" == ".inp" goto bad_ext

set m1=%~dp6
set m2=%~n6
set job=6

if "%OverwriteExistingFiles%" == "yes" goto continue_6
if exist "%m1%%m2%.out" goto output_exists

:continue_6

goto run_PC_GAMESS

:end_6


rem *****************
rem *     JOB 7     *
rem *****************

if "%~7" == "" goto no_arg

echo *********************************************************************
echo.
echo    [ Job 7 ] :   %~nx7
echo.

if "%~x7" == "" goto no_ext
if not "%~x7" == ".inp" goto bad_ext

set m1=%~dp7
set m2=%~n7
set job=7

if "%OverwriteExistingFiles%" == "yes" goto continue_7
if exist "%m1%%m2%.out" goto output_exists

:continue_7

goto run_PC_GAMESS

:end_7


rem *****************
rem *     JOB 8     *
rem *****************

if "%~8" == "" goto no_arg

echo *********************************************************************
echo.
echo    [ Job 8 ] :   %~nx8
echo.

if "%~x8" == "" goto no_ext
if not "%~x8" == ".inp" goto bad_ext

set m1=%~dp8
set m2=%~n8
set job=8

if "%OverwriteExistingFiles%" == "yes" goto continue_8
if exist "%m1%%m2%.out" goto output_exists

:continue_8

goto run_PC_GAMESS

:end_8


rem *****************
rem *     JOB 9     *
rem *****************

if "%~9" == "" goto no_arg

echo *********************************************************************
echo.
echo    [ Job 9 ] :   %~nx9
echo.

if "%~x9" == "" goto no_ext
if not "%~x9" == ".inp" goto bad_ext

set m1=%~dp9
set m2=%~n9
set job=9

if "%OverwriteExistingFiles%" == "yes" goto continue_9
if exist "%m1%%m2%.out" goto output_exists

:continue_9

goto run_PC_GAMESS

:end_9

rem ======= End of Job(s) ========

pause
exit


rem ################################################################

:run_PC_GAMESS

cd /D "%GAMESS_Base%"

if exist CIVECTR.OLD  del CIVECTR.OLD
if exist CIVECTR      ren CIVECTR  CIVECTR.OLD

if exist IRCDATA.OLD  del IRCDATA.OLD
if exist IRCDATA      ren IRCDATA  IRCDATA.OLD

if exist PUNCH.OLD    del PUNCH.OLD
if exist PUNCH        ren PUNCH  PUNCH.OLD

echo on
%GAMESS_Exe%  -i "%m1%%m2%.inp"  > "%m1%%m2%.out"
@echo off

rem Note that -o option for command line execution of PC GAMESS
rem may not redirect output to %m1%%m2%.out in some cases.

echo Execution terminated
echo.

if exist PUNCH   copy PUNCH   "%m1%%m2%.pun"
if exist PUNCH   echo PUNCH was copied to "%m1%%m2%.pun"
echo.
if exist IRCDATA copy IRCDATA "%m1%%m2%.irc"
if exist IRCDATA echo IRCDATA was copied to "%m1%%m2%.irc"


if "%job%" == "1" goto end_1
if "%job%" == "2" goto end_2
if "%job%" == "3" goto end_3
if "%job%" == "4" goto end_4
if "%job%" == "5" goto end_5
if "%job%" == "6" goto end_6
if "%job%" == "7" goto end_7
if "%job%" == "8" goto end_8
if "%job%" == "9" goto end_9

rem ################################################################

:output_exists

echo Output file "%m2%.out" already exists! 
set /P ans=Overwrite it?  (y/n) 

if "%ans%" == "y" goto :yes
if "%ans%" == "n" goto :no

:yes
if "%job%" == "1" goto continue_1
if "%job%" == "2" goto continue_2
if "%job%" == "3" goto continue_3
if "%job%" == "4" goto continue_4
if "%job%" == "5" goto continue_5
if "%job%" == "6" goto continue_6
if "%job%" == "7" goto continue_7
if "%job%" == "8" goto continue_8
if "%job%" == "9" goto continue_9

:no
echo Execution canceled
pause
goto $EOF

:no_arg
if "%~1" == "" echo ********************************************************
if "%~1" == "" echo   DO NOT double click %~nx0.
if "%~1" == "" echo.
if "%~1" == "" echo   To start Firefly (PC GAMESS) calculation,
if "%~1" == "" echo   just drag-and-drop input file(s) on %~nx0.
if "%~1" == "" echo ********************************************************
pause
goto $EOF

:no_ext
echo Invalid input file extension : NO EXTENSION
pause
goto $EOF

:bad_ext
echo Invalid input file extension
pause
goto $EOF

:no_gamess
echo --WARNING--  %GAMESS_Base%\%GAMESS_Exe% does not exist.
echo.
echo --Current Values--
echo GAMESS_Base=%GAMESS_Base%
echo GAMESS_Exe=%GAMESS_Exe%
echo.
echo Correct?
echo If not, specify GAMESS_Base and/or GAMESS_Exe correctly.
echo.
echo.
echo Please note that GAMESS_Base should not be
echo enclosed with double quotation marks.
echo e.g.
echo GAMESS_Base=C:\PCGAMESS          (correct)
echo GAMESS_Base="C:\PCGAMESS"       (incorrect)
echo.
pause

