/*
 * Decompiled with CFR 0.152.
 */
package net.webmo.symmetry.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;

public class Profiler {
    private TreeMap<String, Long> timestamps = new TreeMap();
    private HashSet<String> stillTiming = new HashSet();
    private final long startTime = System.currentTimeMillis();

    public void startTiming(String identifier) {
        this.timestamps.put(identifier, System.currentTimeMillis());
        this.stillTiming.add(identifier);
    }

    public void stopTiming(String identifier) {
        if (this.timestamps.containsKey(identifier)) {
            this.timestamps.put(identifier, System.currentTimeMillis() - this.timestamps.get(identifier));
            this.stillTiming.remove(identifier);
        } else {
            System.err.println("No profile for '" + identifier + "' exists.");
        }
    }

    public Long getTime(String identifier) {
        if (this.stillTiming.contains(identifier)) {
            System.err.println("'" + identifier + "' is still timing. Please stop timing first.");
            return -1L;
        }
        return this.timestamps.get(identifier);
    }

    public String getResults() {
        if (this.stillTiming.size() > 0) {
            System.err.println("The following profiles are still timing:\n");
            for (String str : this.stillTiming) {
                System.err.print("'" + str + "'   ");
            }
            System.err.println("\nPlease stop them before retrieving results.");
            return null;
        }
        StringBuffer resultBuffer = new StringBuffer();
        for (Map.Entry<String, Long> result : this.timestamps.entrySet()) {
            resultBuffer.append(String.format("%s took %.5f seconds%n", result.getKey(), (double)result.getValue().longValue() / 1000.0));
        }
        long totalTime = System.currentTimeMillis() - this.startTime;
        resultBuffer.append(String.format("%nTotal run time was %.5f seconds.%n", (double)totalTime / 1000.0));
        return resultBuffer.toString();
    }

    public void getLongestProfiles(int numDesired) {
        long totalTime = System.currentTimeMillis() - this.startTime;
        System.out.println("Longest Running Profiles:\n");
        ArrayList<Map.Entry<String, Long>> sortedResults = new ArrayList<Map.Entry<String, Long>>();
        for (Map.Entry<String, Long> result : this.timestamps.entrySet()) {
            if (sortedResults.size() == 0) {
                sortedResults.add(result);
                continue;
            }
            int i = 0;
            while (i < sortedResults.size()) {
                Map.Entry otherResult = (Map.Entry)sortedResults.get(i);
                if (result.getValue() > (Long)otherResult.getValue()) {
                    sortedResults.add(sortedResults.indexOf(otherResult), result);
                    i = sortedResults.size();
                }
                if (i == sortedResults.size() - 1) {
                    sortedResults.add(result);
                    i = sortedResults.size();
                }
                ++i;
            }
        }
        if (sortedResults.size() < numDesired) {
            numDesired = sortedResults.size();
        }
        int i = 0;
        while (i < numDesired) {
            Map.Entry result = (Map.Entry)sortedResults.get(i);
            double percent = (double)((Long)result.getValue()).longValue() / (double)totalTime * 100.0;
            System.out.format("%s took %.5f seconds (%.1f%%)%n", result.getKey(), (double)((Long)result.getValue()).longValue() / 1000.0, percent);
            ++i;
        }
    }

    public void printResults() {
        System.out.println(this.getResults());
    }
}

