/*
 * Decompiled with CFR 0.152.
 */
package net.webmo.symmetry.elements;

import net.webmo.symmetry.elements.Element;
import net.webmo.symmetry.util.Matrix4D;
import net.webmo.symmetry.util.Point3D;

public class Reflection
extends Element {
    private Point3D point;
    private Point3D normal;
    private Matrix4D reflectOp = new Matrix4D();

    public Reflection(Point3D point, Point3D normal) {
        this.point = new Point3D(point);
        this.normal = new Point3D(normal);
        this.normal.unit();
        double a = normal.x / normal.length();
        double b = normal.y / normal.length();
        double c = normal.z / normal.length();
        double[][] m = this.reflectOp.matrix;
        m[0][0] = -(a * a) + b * b + c * c;
        m[0][1] = -2.0 * a * b;
        m[0][2] = -2.0 * a * c;
        m[1][0] = -2.0 * a * b;
        m[1][1] = a * a - b * b + c * c;
        m[1][2] = -2.0 * b * c;
        m[2][0] = -2.0 * a * c;
        m[2][1] = -2.0 * b * c;
        m[2][2] = a * a + b * b - c * c;
    }

    public Point3D doOperation(Point3D before) {
        Point3D oldCoords = before.sub(this.point);
        Point3D newCoords = new Point3D();
        double[][] m = this.reflectOp.matrix;
        newCoords.x = m[0][0] * oldCoords.x + m[0][1] * oldCoords.y + m[0][2] * oldCoords.z;
        newCoords.y = m[1][0] * oldCoords.x + m[1][1] * oldCoords.y + m[1][2] * oldCoords.z;
        newCoords.z = m[2][0] * oldCoords.x + m[2][1] * oldCoords.y + m[2][2] * oldCoords.z;
        newCoords = newCoords.add(this.point);
        return newCoords;
    }

    public Point3D getPoint() {
        return this.point;
    }

    public Point3D getNormal() {
        return this.normal;
    }

    public int getDegree() {
        return 1;
    }

    public String getName() {
        return "sigma";
    }

    public int getNumUniqueOperations() {
        return 1;
    }

    public boolean equals(Object other) {
        if (super.equals(other)) {
            if (other instanceof Reflection) {
                Reflection otherRef = (Reflection)other;
                return this.eqPoint(this.point, otherRef.point) && this.eqAxes(this.normal, otherRef.normal);
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return String.valueOf(this.getName()) + " normal to " + this.normal;
    }
}

