/*
 * Decompiled with CFR 0.152.
 */
package net.webmo.symmetry.elements;

import net.webmo.symmetry.elements.Rotation;
import net.webmo.symmetry.util.Matrix4D;
import net.webmo.symmetry.util.Point3D;

public class ProperRotation
extends Rotation {
    public static final int C_INFINITY = -1;
    private Matrix4D rotateOp = new Matrix4D();

    public ProperRotation(Point3D point, Point3D axis, int n) {
        super(point, axis, n);
        axis = this.axis;
        if (n == -1) {
            this.distance = 0.0;
        }
        double angle = Math.PI * 2 / (double)n;
        double c = Math.cos(angle);
        double s = Math.sin(angle);
        double[][] m = this.rotateOp.matrix;
        m[0][0] = c + (1.0 - c) * axis.x * axis.x;
        m[0][1] = (1.0 - c) * axis.x * axis.y - s * axis.z;
        m[0][2] = (1.0 - c) * axis.x * axis.z + s * axis.y;
        m[1][0] = (1.0 - c) * axis.x * axis.y + s * axis.z;
        m[1][1] = c + (1.0 - c) * axis.y * axis.y;
        m[1][2] = (1.0 - c) * axis.z * axis.y - s * axis.x;
        m[2][0] = (1.0 - c) * axis.x * axis.z - s * axis.y;
        m[2][1] = (1.0 - c) * axis.y * axis.z + s * axis.x;
        m[2][2] = c + (1.0 - c) * axis.z * axis.z;
    }

    public Point3D doOperation(Point3D before) {
        if (this.n == -1) {
            return before;
        }
        Point3D oldCoords = before.sub(this.point);
        Point3D newCoords = new Point3D();
        double[][] m = this.rotateOp.matrix;
        newCoords.x = m[0][0] * oldCoords.x + m[0][1] * oldCoords.y + m[0][2] * oldCoords.z;
        newCoords.y = m[1][0] * oldCoords.x + m[1][1] * oldCoords.y + m[1][2] * oldCoords.z;
        newCoords.z = m[2][0] * oldCoords.x + m[2][1] * oldCoords.y + m[2][2] * oldCoords.z;
        newCoords = newCoords.add(this.point);
        return newCoords;
    }

    public int getNumUniqueOperations() {
        int degree = 1;
        int i = 2;
        while (i < this.n) {
            if (!(this.n % 2 == 0 && i % 2 == 0 || this.n % 3 == 0 && i % 3 == 0 || this.n % 5 == 0 && i % 5 == 0)) {
                ++degree;
            }
            ++i;
        }
        return degree;
    }

    public String getName() {
        if (this.n == -1) {
            return "C-infinity";
        }
        return "C" + this.n;
    }

    public boolean equals(Object other) {
        if (super.equals(other)) {
            if (other instanceof ProperRotation) {
                ProperRotation otherRot = (ProperRotation)other;
                return this.eqPoint(this.point, otherRot.point) && this.eqAxes(this.axis, otherRot.axis) && this.n == otherRot.n;
            }
            return false;
        }
        return false;
    }
}

