/*
 * Decompiled with CFR 0.152.
 */
package net.webmo.symmetry.elements;

import net.webmo.symmetry.elements.Element;
import net.webmo.symmetry.util.Point3D;

public class Inversion
extends Element {
    private Point3D point;

    public Inversion(Point3D center) {
        this.point = new Point3D(center);
        this.distance = -1.0;
    }

    public Point3D doOperation(Point3D before) {
        Point3D newPos = new Point3D();
        newPos.x = 2.0 * this.point.x - before.x;
        newPos.y = 2.0 * this.point.y - before.y;
        newPos.z = 2.0 * this.point.z - before.z;
        return newPos;
    }

    public String getName() {
        return "i";
    }

    public Point3D getPosition() {
        return this.point;
    }

    public int getDegree() {
        return 1;
    }

    public int getNumUniqueOperations() {
        return 1;
    }

    public boolean equals(Object other) {
        if (super.equals(other)) {
            if (other instanceof Inversion) {
                Inversion otherInv = (Inversion)other;
                return this.point.x == otherInv.point.x && this.point.y == otherInv.point.y && this.point.z == otherInv.point.z;
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return String.valueOf(this.getName()) + " at " + this.point;
    }
}

