/*
 * Decompiled with CFR 0.152.
 */
package net.webmo.symmetry;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.webmo.symmetry.elements.Element;
import net.webmo.symmetry.elements.ImproperRotation;
import net.webmo.symmetry.elements.Inversion;
import net.webmo.symmetry.elements.ProperRotation;
import net.webmo.symmetry.elements.Reflection;
import net.webmo.symmetry.elements.Rotation;
import net.webmo.symmetry.molecule.Atom;
import net.webmo.symmetry.util.Point3D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PointGroup {
    public static final double SYMMETRIZE_TOLERANCE = 0.15;
    private ArrayList<Element> elements;
    private ArrayList<Atom> atoms;
    private ArrayList<Atom> uniqueAtoms;
    private String name;
    private boolean isCubicGroup;
    private double distance;
    private int numExtraElements;
    private int numMissingElements;

    public PointGroup(ArrayList<Element> elements, ArrayList<Atom> atoms, PointGroups name) {
        this.elements = elements;
        this.atoms = new ArrayList<Atom>(atoms);
        this.name = name.toString();
        this.isCubicGroup = name.isCubic();
    }

    private void findUniqueAtoms(double tolerance) {
        this.uniqueAtoms = new ArrayList();
        ArrayList<Atom> generatedAtoms = new ArrayList<Atom>();
        for (Atom a : this.atoms) {
            a.setSymmetryUnique(true);
        }
        int atomsFinishedGenerating = 0;
        this.atoms.get(0).setSymmetryUnique(true);
        int i = 0;
        while (i < this.atoms.size()) {
            if (this.atoms.get(i).isSymmetryUnique()) {
                generatedAtoms.add(this.atoms.get(i));
                int j = atomsFinishedGenerating;
                while (j < generatedAtoms.size()) {
                    for (Element elem : this.elements) {
                        Atom startAtom = elem.doOperation((Atom)generatedAtoms.get(j));
                        int n = 0;
                        while (n < elem.getDegree()) {
                            Atom closestAtom = startAtom.findClosestAtom(this.atoms);
                            if (startAtom.distance(closestAtom) < this.UNIQUENESS_THRESHOLD(tolerance) && closestAtom != startAtom && !generatedAtoms.contains(closestAtom)) {
                                closestAtom.setSymmetryUnique(false);
                                generatedAtoms.add(closestAtom);
                            }
                            startAtom = closestAtom;
                            ++n;
                        }
                    }
                    ++atomsFinishedGenerating;
                    ++j;
                }
            }
            ++i;
        }
        for (Atom a : generatedAtoms) {
            if (!a.isSymmetryUnique()) continue;
            this.uniqueAtoms.add(a);
        }
    }

    private double UNIQUENESS_THRESHOLD(double tolerance) {
        return Math.max(0.2, tolerance * 2.0);
    }

    private ArrayList<Atom> createSymmetrizedMolecule() {
        ArrayList<Atom> newMolecule = new ArrayList<Atom>(this.atoms.size());
        HashMap<Integer, Atom> orderMap = new HashMap<Integer, Atom>();
        newMolecule.addAll(this.uniqueAtoms);
        for (Atom unique : this.uniqueAtoms) {
            orderMap.put(this.atoms.indexOf(unique), unique);
        }
        for (Element elem : this.elements) {
            int i = 0;
            while (i < newMolecule.size()) {
                Atom atom = (Atom)newMolecule.get(i);
                int degree = elem.getDegree();
                if (degree > 1) {
                    --degree;
                }
                int n = 0;
                while (n < degree) {
                    Atom closestAtom;
                    Atom newAtom = elem.doOperation(atom);
                    if (newAtom.distance(closestAtom = newAtom.findClosestAtom(newMolecule)) > 0.2) {
                        newAtom.setSymmetryUnique(false);
                        newMolecule.add(newAtom);
                        Atom closestOriginalAtom = newAtom.findClosestAtom(this.atoms);
                        int index = this.atoms.indexOf(closestOriginalAtom);
                        orderMap.put(index, newAtom);
                    }
                    atom = newAtom;
                    ++n;
                }
                ++i;
            }
        }
        int i = 0;
        while (i < newMolecule.size()) {
            newMolecule.set(i, (Atom)orderMap.get(i));
            ++i;
        }
        ArrayList<Atom> finalMolecule = new ArrayList<Atom>();
        int i2 = 0;
        while (i2 < newMolecule.size()) {
            if (newMolecule.get(i2) != null) {
                finalMolecule.add((Atom)newMolecule.get(i2));
            }
            ++i2;
        }
        if (finalMolecule.size() != this.atoms.size()) {
            System.err.println("The number of generated atoms does not match the initial molecule!");
            throw new RuntimeException("The number of generated atoms does not match the initial molecule!");
        }
        return finalMolecule;
    }

    public ArrayList<Atom> symmetrizeMolecule(double tolerance) {
        if (this.elements.size() == 0) {
            return this.atoms;
        }
        ArrayList<Element> oldElements = new ArrayList<Element>(this.elements);
        ArrayList<Object> idealElements = new ArrayList<Element>();
        Element startElement = this.elements.get(0);
        for (Element elem : this.elements) {
            if (elem.getDegree() <= startElement.getDegree() || this.isCubicGroup && !(elem instanceof ProperRotation)) continue;
            startElement = elem;
        }
        idealElements.add(startElement);
        oldElements.remove(startElement);
        if (this.name.equals("T") || this.name.equals("Th") || this.name.equals("Td")) {
            int numReflections = this.name.equals("Th") ? 3 : (this.name.equals("Td") ? 6 : 0);
            idealElements = this.symmetrizeTetrahedralElements((ProperRotation)startElement, numReflections);
            oldElements.clear();
        } else if (this.name.equals("O") || this.name.equals("Oh")) {
            idealElements = this.symmetrizeOctahedralElements((ProperRotation)startElement, this.name.equals("Oh"));
            oldElements.clear();
        } else if (this.name.equals("I") || this.name.equals("Ih")) {
            idealElements = this.symmetrizeIcosahedralElements((ProperRotation)startElement, this.name.equals("Ih"));
            oldElements.clear();
        } else if (this.name.contains("inf")) {
            idealElements = this.elements;
            oldElements.clear();
        } else if (startElement.getDegree() > 1) {
            Rotation primaryRotation = (Rotation)startElement;
            Point3D center = primaryRotation.getPoint();
            double maxAngle = Math.PI * 2 / (double)primaryRotation.getDegree();
            if (primaryRotation instanceof ProperRotation) {
                maxAngle /= 2.0;
            }
            Point3D rotAxis = null;
            Point3D refAxis = null;
            int i = 0;
            while (i < oldElements.size()) {
                Element elem = oldElements.get(i);
                if (elem instanceof Inversion) {
                    idealElements.add(new Inversion(center));
                    oldElements.remove(elem);
                    --i;
                } else {
                    Point3D currentAxis = null;
                    Point3D otherAxis = null;
                    Point3D newAxis = null;
                    double dotprod = 0.0;
                    if (elem instanceof Rotation) {
                        newAxis = ((Rotation)elem).getAxis();
                        dotprod = newAxis.dotProd(primaryRotation.getAxis());
                        currentAxis = rotAxis;
                        otherAxis = refAxis;
                    } else if (elem instanceof Reflection) {
                        newAxis = ((Reflection)elem).getNormal();
                        dotprod = newAxis.dotProd(primaryRotation.getAxis());
                        currentAxis = refAxis;
                        otherAxis = rotAxis;
                    }
                    if (Math.abs(1.0 - Math.abs(dotprod)) < 0.15) {
                        if (elem instanceof ProperRotation) {
                            idealElements.add(new ProperRotation(center, primaryRotation.getAxis(), ((ProperRotation)elem).getDegree()));
                        } else if (elem instanceof ImproperRotation) {
                            idealElements.add(new ImproperRotation(center, primaryRotation.getAxis(), ((ImproperRotation)elem).getDegree()));
                        } else if (elem instanceof Reflection) {
                            idealElements.add(new Reflection(center, primaryRotation.getAxis()));
                        }
                        oldElements.remove(elem);
                        --i;
                    } else if (Math.abs(dotprod) < 0.15) {
                        if (currentAxis == null) {
                            currentAxis = newAxis;
                            Point3D rotPoint = center.add(currentAxis);
                            double angle = 1.5707963267948966 - currentAxis.angleBetween(primaryRotation.getAxis());
                            rotPoint = rotPoint.rotate(center, currentAxis.crossProd(primaryRotation.getAxis()), -angle);
                            currentAxis = rotPoint.sub(center);
                            if (otherAxis != null) {
                                double currentAngle = currentAxis.angleBetween(otherAxis);
                                double correctAngle = (double)Math.round(currentAngle / (maxAngle / 2.0)) * (maxAngle / 2.0);
                                double angleOffset = correctAngle - currentAngle;
                                rotPoint = center.add(currentAxis);
                                rotPoint = rotPoint.rotate(center, primaryRotation.getAxis(), angleOffset);
                                currentAxis = rotPoint.sub(center);
                            }
                        } else {
                            currentAxis = currentAxis.add(center);
                            currentAxis = currentAxis.rotate(center, primaryRotation.getAxis(), maxAngle);
                            currentAxis = currentAxis.sub(center);
                        }
                        if (elem instanceof ProperRotation) {
                            idealElements.add(new ProperRotation(center, currentAxis, ((ProperRotation)elem).getDegree()));
                            rotAxis = currentAxis;
                            refAxis = otherAxis;
                        } else if (elem instanceof ImproperRotation) {
                            idealElements.add(new ImproperRotation(center, currentAxis, ((ImproperRotation)elem).getDegree()));
                            rotAxis = currentAxis;
                            refAxis = otherAxis;
                        } else if (elem instanceof Reflection) {
                            idealElements.add(new Reflection(center, currentAxis));
                            refAxis = currentAxis;
                            rotAxis = otherAxis;
                        }
                        oldElements.remove(elem);
                        --i;
                    }
                }
                ++i;
            }
        }
        if (oldElements.size() != 0) {
            System.err.println("Something went wrong! Not all elements copied correctly!");
        }
        this.elements = idealElements;
        this.findUniqueAtoms(tolerance);
        this.adjustUniqueAtomsToElements(tolerance);
        ArrayList<Atom> symMol = this.createSymmetrizedMolecule();
        return symMol;
    }

    private ArrayList<Element> symmetrizeTetrahedralElements(ProperRotation primaryRotation, int numRefs) {
        ArrayList<Element> symmetrizedElements = new ArrayList<Element>();
        ArrayList<Point3D> c3s = new ArrayList<Point3D>();
        Point3D center = primaryRotation.getPoint();
        Point3D rotAxis = new Point3D(0.0, 0.0, 1.0).crossProd(primaryRotation.getAxis());
        double overallAngle = 0.7853981633974483;
        ProperRotation firstRot = null;
        for (Element elem : this.elements) {
            if (!(elem instanceof ProperRotation) || (firstRot = (ProperRotation)elem).getDegree() != 2) continue;
            double dotprod = firstRot.getAxis().dotProd(primaryRotation.getAxis());
            if (primaryRotation.getDegree() == 3) {
                primaryRotation = firstRot;
                continue;
            }
            if (!(Math.abs(dotprod) < 0.1)) continue;
            rotAxis = firstRot.getAxis().crossProd(primaryRotation.getAxis());
            break;
        }
        rotAxis.unit();
        symmetrizedElements.add(new ProperRotation(center, primaryRotation.getAxis(), 2));
        if (numRefs == 6) {
            symmetrizedElements.add(new ImproperRotation(center, primaryRotation.getAxis(), 4));
        }
        int i = 0;
        while (i < primaryRotation.getDegree() * 2) {
            if (i % 2 == 0) {
                double rotAngle = 1.5707963267948966;
                Point3D newAxis = primaryRotation.getAxis().rotate(Point3D.O, rotAxis, rotAngle);
                symmetrizedElements.add(new ProperRotation(center, newAxis, 2));
                if (numRefs == 3) {
                    symmetrizedElements.add(new Reflection(center, newAxis));
                } else if (numRefs == 6) {
                    symmetrizedElements.add(new ImproperRotation(center, newAxis, 4));
                }
            } else {
                double rotC3Angle2 = 2.18627603546433;
                double rotC3Angle1 = 1.5707963267948966 - (rotC3Angle2 - 1.5707963267948966);
                Point3D newAxis = primaryRotation.getAxis().rotate(Point3D.O, rotAxis, rotC3Angle1);
                symmetrizedElements.add(new ProperRotation(center, newAxis, 3));
                if (numRefs == 3) {
                    symmetrizedElements.add(new ImproperRotation(center, newAxis, 6));
                }
                c3s.add(newAxis);
                newAxis = primaryRotation.getAxis().rotate(Point3D.O, rotAxis, rotC3Angle2);
                symmetrizedElements.add(new ProperRotation(center, newAxis, 3));
                if (numRefs == 3) {
                    symmetrizedElements.add(new ImproperRotation(center, newAxis, 6));
                }
                c3s.add(newAxis);
            }
            rotAxis = rotAxis.rotate(Point3D.O, primaryRotation.getAxis(), overallAngle);
            ++i;
        }
        if (numRefs == 3) {
            symmetrizedElements.add(new Inversion(center));
        } else if (numRefs == 6) {
            i = 0;
            while (i < c3s.size() - 1) {
                int j = i;
                while (j < c3s.size()) {
                    Reflection ref = new Reflection(center, ((Point3D)c3s.get(i)).crossProd((Point3D)c3s.get(j)));
                    if (!ref.getNormal().equals(new Point3D(0.0, 0.0, 0.0))) {
                        symmetrizedElements.add(ref);
                    }
                    ++j;
                }
                ++i;
            }
        }
        return symmetrizedElements;
    }

    private ArrayList<Element> symmetrizeOctahedralElements(ProperRotation primaryRotation, boolean isOh) {
        ArrayList<Element> symmetrizedElements = new ArrayList<Element>();
        Point3D center = primaryRotation.getPoint();
        Point3D rotAxis = new Point3D(0.0, 0.0, 1.0).crossProd(primaryRotation.getAxis());
        double overallAngle = 0.7853981633974483;
        for (Element elem : this.elements) {
            ProperRotation firstRot;
            double dotprod;
            if (!(elem instanceof ProperRotation) || !((dotprod = (firstRot = (ProperRotation)elem).getAxis().dotProd(primaryRotation.getAxis())) > 0.1) || !(dotprod < 0.9) || firstRot.getDegree() != 2) continue;
            rotAxis = firstRot.getAxis().crossProd(primaryRotation.getAxis());
        }
        rotAxis.unit();
        symmetrizedElements.add(new ProperRotation(center, primaryRotation.getAxis(), 2));
        if (isOh) {
            symmetrizedElements.add(new ImproperRotation(center, primaryRotation.getAxis(), 4));
            symmetrizedElements.add(new Reflection(center, primaryRotation.getAxis()));
        }
        int i = 0;
        while (i < primaryRotation.getDegree()) {
            if (i % 2 == 0) {
                double rotAngle = 0.7853981633974483;
                Point3D newAxis = primaryRotation.getAxis().rotate(Point3D.O, rotAxis, rotAngle);
                symmetrizedElements.add(new ProperRotation(center, newAxis, 2));
                if (isOh) {
                    symmetrizedElements.add(new Reflection(center, newAxis));
                }
                newAxis = primaryRotation.getAxis().rotate(Point3D.O, rotAxis, 2.0 * rotAngle);
                symmetrizedElements.add(new ProperRotation(center, newAxis, 2));
                symmetrizedElements.add(new ProperRotation(center, newAxis, 4));
                if (isOh) {
                    symmetrizedElements.add(new ImproperRotation(center, newAxis, 4));
                    symmetrizedElements.add(new Reflection(center, newAxis));
                }
                newAxis = primaryRotation.getAxis().rotate(Point3D.O, rotAxis, 3.0 * rotAngle);
                symmetrizedElements.add(new ProperRotation(center, newAxis, 2));
                if (isOh) {
                    symmetrizedElements.add(new Reflection(center, newAxis));
                }
            } else {
                double rotAngleC3 = 0.955316618172587;
                double rotAngleC2 = 1.5707963267948966;
                double rotAngle2C3 = 2.186276035417206;
                Point3D newAxis = primaryRotation.getAxis().rotate(Point3D.O, rotAxis, rotAngleC3);
                symmetrizedElements.add(new ProperRotation(center, newAxis, 3));
                if (isOh) {
                    symmetrizedElements.add(new ImproperRotation(center, newAxis, 6));
                }
                newAxis = primaryRotation.getAxis().rotate(Point3D.O, rotAxis, rotAngleC2);
                symmetrizedElements.add(new ProperRotation(center, newAxis, 2));
                if (isOh) {
                    symmetrizedElements.add(new Reflection(center, newAxis));
                }
                newAxis = primaryRotation.getAxis().rotate(Point3D.O, rotAxis, rotAngle2C3);
                symmetrizedElements.add(new ProperRotation(center, newAxis, 3));
                if (isOh) {
                    symmetrizedElements.add(new ImproperRotation(center, newAxis, 6));
                }
            }
            rotAxis = rotAxis.rotate(Point3D.O, primaryRotation.getAxis(), overallAngle);
            ++i;
        }
        symmetrizedElements.add(new Inversion(center));
        return symmetrizedElements;
    }

    private ArrayList<Element> symmetrizeIcosahedralElements(ProperRotation primaryRotation, boolean isIh) {
        ArrayList<Element> symmetrizedElements = new ArrayList<Element>();
        Point3D center = primaryRotation.getPoint();
        Point3D rotAxis = new Point3D(0.0, 0.0, 1.0).crossProd(primaryRotation.getAxis());
        double overallAngle = 0.3141592653589793;
        double vertexAngle = 1.107148717394026;
        double faceAngle = (Math.PI - vertexAngle) / 2.0;
        double c3Angle = 0.3648638279583356;
        for (Element elem : this.elements) {
            if (!(elem instanceof ProperRotation)) continue;
            ProperRotation firstRot = (ProperRotation)elem;
            double dotprod = firstRot.getAxis().dotProd(primaryRotation.getAxis());
            if (!(Math.abs(Math.cos(vertexAngle) - dotprod) < 0.1) || firstRot.getDegree() != 5) continue;
            rotAxis = firstRot.getAxis().crossProd(primaryRotation.getAxis());
        }
        rotAxis.unit();
        symmetrizedElements.add(new ProperRotation(center, primaryRotation.getAxis(), 5));
        if (isIh) {
            symmetrizedElements.add(new ImproperRotation(center, primaryRotation.getAxis(), 10));
        }
        int i = 0;
        while (i < primaryRotation.getDegree() * 2) {
            Point3D newAxis;
            if (i % 4 == 0) {
                newAxis = primaryRotation.getAxis().rotate(Point3D.O, rotAxis, faceAngle + c3Angle);
                symmetrizedElements.add(new ProperRotation(center, newAxis, 3));
                if (isIh) {
                    symmetrizedElements.add(new ImproperRotation(center, newAxis, 6));
                }
                newAxis = primaryRotation.getAxis().rotate(Point3D.O, rotAxis, faceAngle);
                symmetrizedElements.add(new ProperRotation(center, newAxis, 2));
                if (isIh) {
                    symmetrizedElements.add(new Reflection(center, newAxis));
                }
                newAxis = primaryRotation.getAxis().rotate(Point3D.O, rotAxis, faceAngle + c3Angle);
                symmetrizedElements.add(new ProperRotation(center, newAxis, 3));
                if (isIh) {
                    symmetrizedElements.add(new ImproperRotation(center, newAxis, 6));
                }
                newAxis = primaryRotation.getAxis().rotate(Point3D.O, rotAxis, 2.0 * faceAngle);
                symmetrizedElements.add(new ProperRotation(center, newAxis, 5));
                if (isIh) {
                    symmetrizedElements.add(new ImproperRotation(center, newAxis, 10));
                }
                newAxis = primaryRotation.getAxis().rotate(Point3D.O, rotAxis, 2.0 * faceAngle + vertexAngle / 2.0);
                symmetrizedElements.add(new ProperRotation(center, newAxis, 2));
                if (isIh) {
                    symmetrizedElements.add(new Reflection(center, newAxis));
                }
            } else if (i % 4 == 2) {
                newAxis = primaryRotation.getAxis().rotate(Point3D.O, rotAxis, vertexAngle / 2.0);
                symmetrizedElements.add(new ProperRotation(center, newAxis, 2));
                if (isIh) {
                    symmetrizedElements.add(new Reflection(center, newAxis));
                }
                newAxis = primaryRotation.getAxis().rotate(Point3D.O, rotAxis, vertexAngle);
                symmetrizedElements.add(new ProperRotation(center, newAxis, 5));
                if (isIh) {
                    symmetrizedElements.add(new ImproperRotation(center, newAxis, 10));
                }
                newAxis = primaryRotation.getAxis().rotate(Point3D.O, rotAxis, vertexAngle + faceAngle - c3Angle);
                symmetrizedElements.add(new ProperRotation(center, newAxis, 3));
                if (isIh) {
                    symmetrizedElements.add(new ImproperRotation(center, newAxis, 6));
                }
                newAxis = primaryRotation.getAxis().rotate(Point3D.O, rotAxis, vertexAngle + faceAngle);
                symmetrizedElements.add(new ProperRotation(center, newAxis, 2));
                if (isIh) {
                    symmetrizedElements.add(new Reflection(center, newAxis));
                }
                newAxis = primaryRotation.getAxis().rotate(Point3D.O, rotAxis, vertexAngle + faceAngle + c3Angle);
                symmetrizedElements.add(new ProperRotation(center, newAxis, 3));
                if (isIh) {
                    symmetrizedElements.add(new ImproperRotation(center, newAxis, 6));
                }
            } else {
                newAxis = primaryRotation.getAxis().rotate(Point3D.O, rotAxis, 1.5707963267948966);
                symmetrizedElements.add(new ProperRotation(center, newAxis, 2));
                if (isIh) {
                    symmetrizedElements.add(new Reflection(center, newAxis));
                }
            }
            rotAxis = rotAxis.rotate(Point3D.O, primaryRotation.getAxis(), overallAngle);
            ++i;
        }
        symmetrizedElements.add(new Inversion(center));
        return symmetrizedElements;
    }

    private void adjustUniqueAtomsToElements(double tolerance) {
        for (Atom atom : this.uniqueAtoms) {
            for (Element elem : this.elements) {
                Point3D closestPoint;
                if (elem instanceof Rotation) {
                    Rotation rot = (Rotation)elem;
                    closestPoint = Point3D.closestPointOnAxis(atom.getPosition(), rot.getPoint(), rot.getAxis());
                    if (!(atom.getPosition().distance(closestPoint) < this.UNIQUENESS_THRESHOLD(tolerance))) continue;
                    atom.setPosition(closestPoint);
                    continue;
                }
                if (elem instanceof Reflection) {
                    Reflection ref = (Reflection)elem;
                    closestPoint = Point3D.closestPointInPlane(atom.getPosition(), ref.getPoint(), ref.getNormal());
                    if (!(atom.getPosition().distance(closestPoint) < this.UNIQUENESS_THRESHOLD(tolerance))) continue;
                    atom.setPosition(closestPoint);
                    continue;
                }
                if (!(elem instanceof Inversion)) continue;
                Inversion inv = (Inversion)elem;
                if (!(atom.getPosition().distance(inv.getPosition()) < this.UNIQUENESS_THRESHOLD(tolerance))) continue;
                atom.setPosition(inv.getPosition());
            }
        }
    }

    public void setDistance(double distance) {
        this.distance = distance;
    }

    public void setNumExtraElements(int extra) {
        this.numExtraElements = extra;
    }

    public void setNumMissingElements(int missing) {
        this.numMissingElements = missing;
    }

    public double getDistance() {
        return this.distance;
    }

    public String getName() {
        return this.name;
    }

    public int getNumExtraElements() {
        return this.numExtraElements;
    }

    public int getNumMissingElements() {
        return this.numMissingElements;
    }

    public ArrayList<Element> getElements() {
        return this.elements;
    }

    public ArrayList<Atom> getAtoms() {
        return this.atoms;
    }

    public ArrayList<Atom> getUniqueAtoms(double tolerance) {
        if (this.uniqueAtoms == null) {
            this.findUniqueAtoms(tolerance);
        }
        return this.uniqueAtoms;
    }

    public String toString() {
        if (this.name.contains("inf")) {
            return String.valueOf(this.name.substring(0, 1)) + "\u221e" + this.name.substring(this.name.length() - 1, this.name.length());
        }
        return this.name;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PointGroups {
        C1("E"),
        Cs("E, sigma"),
        Ci("E, i"),
        C2("E, C2"),
        C3("E, 2C3"),
        C4("E, 2C4, C2"),
        C5("E, 4C5"),
        C6("E, 2C6, 2C3, C2"),
        C7("E, 6C7"),
        C8("E, 4C8, 2C4, C2, i, sigma"),
        D2("E, 3C2"),
        D3("E, 2C3, 3C2"),
        D4("E, 2C4, 5C2"),
        D5("E, 4C5, 5C2"),
        D6("E, 2C6, 2C3, 7C2"),
        C2v("E, C2, 2sigma"),
        C3v("E, 2C3, 3sigma"),
        C4v("E, 2C4, C2, 4sigma"),
        C5v("E, 4C5, 5sigma"),
        C6v("E, 2C6, 2C3, C2, 6sigma"),
        D2d("E, 3C2, 2S4, 2sigma"),
        D3d("E, 2C3, 3C2, i, 2S6, 3sigma"),
        D4d("E, 2C4, 5C2, 4S8, 4sigma"),
        D5d("E, 4C5, 5C2, i, 4S10, 5sigma"),
        D6d("E, 2C6, 2C3, 7C2, 4S12, 2S4, 6sigma"),
        C2h("E, C2, i, sigma"),
        C3h("E, 2C3, sigma, 2S3"),
        C4h("E, 2C4, C2, i, 2S4, sigma"),
        C5h("E, 4C5, 4S5, sigma"),
        C6h("E, 2C6, 2C3, C2, i, 2S3, 2S6, sigma"),
        D2h("E, 3C2, i, 3sigma"),
        D3h("E, 2C3, 3C2, 2S3, 4sigma"),
        D4h("E, 2C4, 5C2, i, S4, 5sigma"),
        D5h("E, 4C5, 5C2, 4S5, 6sigma"),
        D6h("E, 2C6, 2C3, 7C2, i, 2S3, 2S6, 7sigma"),
        S4("E, C2, 2S4"),
        S6("E, 2C3, i, 2S6"),
        S8("E, 2C4, C2, 4S8"),
        T("E, 8C3, 3C2"),
        Th("E, 8C3, 3C2, i, 8S6, 3sigma"),
        Td("E, 8C3, 3C2, 6S4, 6sigma"),
        O("E, 6C4, 8C3, 9C2"),
        Oh("E, 6C4, 8C3, 9C2, i, 8S6, 6S4, 9sigma"),
        I("E, 24C5, 20C3, 15C2"),
        Ih("E, 24C5, 20C3, 15C2, i, 24S10, 20S6, 15sigma"),
        C_infinity_v("E, C-1"),
        D_infinity_d("E, C-1, i");

        private ArrayList<Operation> operations;
        private final Pattern format = Pattern.compile(", (\\d*)([a-zA-Z]+)(-?\\d*)");

        private PointGroups(String elems) {
            this.operations = this.parseElementText(elems);
        }

        public ArrayList<Operation> getOperations() {
            return this.operations;
        }

        public boolean isCubic() {
            return this == T || this == Th || this == Td || this == O || this == Oh || this == I || this == Ih;
        }

        private ArrayList<Operation> parseElementText(String elemText) {
            elemText = elemText.substring(1);
            this.operations = new ArrayList();
            Matcher match = this.format.matcher(elemText);
            while (match.find()) {
                int num = 1;
                if (!match.group(1).equals("")) {
                    num = Integer.parseInt(match.group(1));
                }
                String name = match.group(2);
                int deg = 1;
                if (!match.group(3).equals("")) {
                    deg = Integer.parseInt(match.group(3));
                    name = deg == -1 ? String.valueOf(name) + "-infinity" : String.valueOf(name) + deg;
                }
                this.operations.add(new Operation(num, name, deg));
            }
            return this.operations;
        }

        public class Operation {
            private int number;
            private String elementType;
            private int degree;

            public Operation(int num, String type, int deg) {
                this.number = num;
                this.elementType = type;
                this.degree = deg;
            }

            public int getNumber() {
                return this.number;
            }

            public String getElementType() {
                return this.elementType;
            }

            public int getDegree() {
                return this.degree;
            }
        }
    }
}

