/*
 * Decompiled with CFR 0.152.
 */
package net.webmo.symmetry;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import net.webmo.symmetry.Symmetry;
import net.webmo.symmetry.SymmetryUnitTest;
import net.webmo.symmetry.molecule.Atom;
import net.webmo.symmetry.molecule.Molecule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Main {
    private static SymmetryUnitTest[] unitTests;
    private static final String TEST_FOLDER_LOCATION = "/test/";
    private static final int OUTPUT_PRECISION = 8;
    public static final int VERBOSE = 2;
    public static final int NORMAL = 1;
    public static final int TERSE = 0;
    private static final String[] options;
    public static int outputLevel;
    public double tolerance = 0.1;
    public String outputFile = null;
    public boolean doUnitTest = false;
    public String inputFile = null;

    static {
        options = new String[]{"-o", "-t", "-v", "-u", "-h"};
        outputLevel = 1;
    }

    public static void main(String[] args) {
        Main runner = new Main();
        runner.parseArgs(args);
    }

    /*
     * Unable to fully structure code
     */
    private void parseArgs(String[] args) {
        if (args.length == 0) {
            this.printUsageAndExit();
        }
        verbositySet = false;
        i = 0;
        while (i < args.length) {
            str = args[i];
            if (str.startsWith("-")) {
                if (str.toLowerCase().equals(Main.options[0])) {
                    if (args.length > i + 1) {
                        if (args[i + 1].startsWith("-")) {
                            this.printUsageAndExit();
                        }
                        this.outputFile = args[i + 1];
                        ++i;
                    } else {
                        this.printUsageAndExit();
                    }
                } else if (str.toLowerCase().equals(Main.options[1])) {
                    if (args.length > i + 1) {
                        try {
                            if (args[i + 1].startsWith("-")) {
                                this.printUsageAndExit();
                            }
                            this.tolerance = Double.parseDouble(args[i + 1]);
                            ++i;
                        }
                        catch (NumberFormatException e) {
                            System.err.println("Tolerance must be a decimal number");
                            System.exit(1);
                        }
                    } else {
                        this.printUsageAndExit();
                    }
                } else if (str.toLowerCase().equals(Main.options[2])) {
                    if (args.length > i + 1) {
                        if (args[i + 1].startsWith("-")) {
                            this.printUsageAndExit();
                        }
                        try {
                            newOutputLevel = Integer.parseInt(args[i + 1]);
                            if (newOutputLevel > 2 || newOutputLevel < 0) {
                                this.printUsageAndExit();
                            }
                            Main.outputLevel = newOutputLevel;
                            verbositySet = true;
                            ++i;
                        }
                        catch (NumberFormatException e) {
                            outputLevelName = args[i + 1];
                            if (outputLevelName.toUpperCase().equals("TERSE")) {
                                Main.outputLevel = 0;
                            } else if (outputLevelName.toUpperCase().equals("NORMAL")) {
                                Main.outputLevel = 1;
                            } else if (outputLevelName.toUpperCase().equals("VERBOSE")) {
                                Main.outputLevel = 2;
                            } else {
                                this.printUsageAndExit();
                            }
                            verbositySet = true;
                            ++i;
                        }
                    } else {
                        this.printUsageAndExit();
                    }
                } else if (str.toLowerCase().equals(Main.options[3])) {
                    this.doUnitTest = true;
                    if (!verbositySet) {
                        Main.outputLevel = 0;
                    }
                } else if (str.toLowerCase().equals(Main.options[4])) {
                    this.printUsageAndExit();
                } else {
                    System.err.println("Unknown option '" + str + "'. Valid options: -o -t -s -v");
                    System.exit(1);
                }
            } else {
                if (i + 1 != args.length) {
                    this.printUsageAndExit();
                }
                this.inputFile = args[i];
            }
            ++i;
        }
        if (this.doUnitTest) {
            this.runUnitTests();
        } else {
            molecule = this.readFile(this.inputFile, false);
            runMolecule = new Symmetry(molecule.getAtoms(), this.inputFile, this.tolerance);
            pointGroups = runMolecule.getPointGroups();
            if (this.outputFile != null) {
                block47: {
                    System.out.println("Which point group would you like to symmetrize to?");
                    ptGrpIndex = -1;
                    pointGroup = null;
                    try {
                        br = new BufferedReader(new InputStreamReader(System.in));
                        pointGroup = br.readLine();
                        ptGrpIndex = Integer.parseInt(pointGroup) - 1;
                        break block47;
                    }
                    catch (IOException e) {
                        System.err.println("Problem reading input from the command line");
                        System.exit(1);
                        break block47;
                    }
                    catch (NumberFormatException e) {
                        i = 0;
                        ** while (i < pointGroups.size())
                    }
lbl-1000:
                    // 1 sources

                    {
                        if (pointGroups.get(i).getName().toLowerCase().equals(pointGroup.toLowerCase())) {
                            ptGrpIndex = i;
                        }
                        ++i;
                        continue;
                    }
lbl102:
                    // 1 sources

                    if (ptGrpIndex == -1) {
                        System.err.println("Point group '" + pointGroup + "' not in list of point groups");
                        System.exit(1);
                    }
                }
                if (ptGrpIndex < pointGroups.size()) {
                    symmetricMolecule = pointGroups.get(ptGrpIndex).symmetrizeMolecule(this.tolerance);
                    this.writeXYZFile(symmetricMolecule, this.outputFile);
                } else {
                    System.err.println("Point group #" + (ptGrpIndex + 1) + " is not a valid option");
                    System.exit(1);
                }
            }
        }
    }

    private void printUsageAndExit() {
        System.err.println("USAGE: symmetrizer.jar [OPTIONS...] file");
        System.err.println("OPTIONS: [-u] [-o outputFile] [-v 0=TERSE|1=NORMAL|2=VERBOSE] [-t tolerance]");
        System.err.println("");
        System.err.println("file:\t An XYZ format description of the molecular coordinates");
        System.err.println("-u:\t Executes a unit test on a variety of built-in test cases");
        System.err.println("-o:\t Output file to which to write the symmetrized geometry");
        System.err.println("-v:\t Flag controlling verbosity of output");
        System.err.println("-t:\t Specifies the error tolerence when searching for symmetry elements");
        System.exit(1);
    }

    private void setUpUnitTests() {
        unitTests = new SymmetryUnitTest[21];
        double tolerance = 0.1;
        double sloppy_tolerance = 0.3;
        Main.unitTests[0] = new SymmetryUnitTest("CO2.xyz", tolerance, "D_infinity_d");
        Main.unitTests[1] = new SymmetryUnitTest("C2O.xyz", tolerance, "C_infinity_v");
        Main.unitTests[2] = new SymmetryUnitTest("15AtomMolecule.xyz", tolerance, "Cs");
        Main.unitTests[3] = new SymmetryUnitTest("WaterIdeal.xyz", tolerance, "C2v");
        Main.unitTests[4] = new SymmetryUnitTest("AmmoniaMech.xyz", tolerance, "C3v");
        Main.unitTests[5] = new SymmetryUnitTest("BenzeneMech.xyz", tolerance, "D6h");
        Main.unitTests[6] = new SymmetryUnitTest("StaggeredEthane.xyz", tolerance, "D3d");
        Main.unitTests[7] = new SymmetryUnitTest("DimanganeseDecacarbonyl.xyz", sloppy_tolerance, "D4d");
        Main.unitTests[8] = new SymmetryUnitTest("MethaneIdeal.xyz", tolerance, "Td");
        Main.unitTests[9] = new SymmetryUnitTest("NeopentaneTwisted.xyz", tolerance, "T");
        Main.unitTests[10] = new SymmetryUnitTest("Hexapyridineiron.xyz", tolerance, "Th");
        Main.unitTests[11] = new SymmetryUnitTest("Cubane.xyz", tolerance, "Oh");
        Main.unitTests[12] = new SymmetryUnitTest("SulfurHexafluoride.xyz", tolerance, "Oh");
        Main.unitTests[13] = new SymmetryUnitTest("B12H12_2-.xyz", tolerance, "Ih");
        Main.unitTests[14] = new SymmetryUnitTest("Buckyball.xyz", tolerance, "Ih");
        Main.unitTests[15] = new SymmetryUnitTest("Taxol.xyz", tolerance, "C1");
        Main.unitTests[16] = new SymmetryUnitTest("Ligand.xyz", sloppy_tolerance, "Cs");
        Main.unitTests[17] = new SymmetryUnitTest("NickelTetracarbonyl.xyz", tolerance, "Td");
        Main.unitTests[18] = new SymmetryUnitTest("BrF5.xyz", tolerance, "C4v");
        Main.unitTests[19] = new SymmetryUnitTest("c36h60o30.xyz", tolerance, "C6");
        Main.unitTests[20] = new SymmetryUnitTest("improper_rotations.xyz", tolerance, "S4");
    }

    private void runUnitTests() {
        this.setUpUnitTests();
        boolean[] results = new boolean[unitTests.length];
        int numFailed = 0;
        int i = 0;
        while (i < unitTests.length) {
            SymmetryUnitTest test = unitTests[i];
            Molecule molecule = this.readFile(TEST_FOLDER_LOCATION + test.getFileName(), true);
            Symmetry runMolecule = new Symmetry(molecule.getAtoms(), test.getFileName(), test.getTolerance());
            results[i] = runMolecule.getPointGroups().get(0).getName().equals(test.getPointGroupName());
            if (!results[i]) {
                ++numFailed;
            }
            ++i;
        }
        System.out.println("--------------------------------------------------------");
        System.out.println("Unit Test Results:");
        System.out.println("--------------------------------------------------------");
        i = 0;
        while (i < unitTests.length) {
            System.out.println(String.valueOf(unitTests[i].getFileName()) + ": " + (results[i] ? "Passed" : "** Failed **"));
            ++i;
        }
        System.out.println("--------------------------------------------------------");
        System.out.println(String.valueOf(numFailed % unitTests.length == 0 ? "All Tests " : String.valueOf(numFailed) + " Test(s) ") + (numFailed == 0 ? "Passed" : "Failed"));
        System.out.println("--------------------------------------------------------");
    }

    private void writeXYZFile(ArrayList<Atom> atoms, String filename) {
        if (!filename.substring(filename.length() - 4, filename.length()).equals(".xyz")) {
            filename = String.valueOf(filename) + ".xyz";
        }
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(filename));
            for (Atom atom : atoms) {
                writer.write(String.format("%s\t%.8f %.8f %.8f %s%n", atom.getSymbol(), atom.getPosition().x, atom.getPosition().y, atom.getPosition().z, atom.isSymmetryUnique() ? "*" : ""));
            }
            writer.close();
        }
        catch (IOException e) {
            System.err.println("A problem was encountered writing the file.");
            e.printStackTrace();
        }
    }

    private Molecule readFile(String filename, boolean isInternal) {
        Molecule molecule = new Molecule();
        try {
            if (!filename.substring(filename.length() - 4, filename.length()).equals(".xyz")) {
                System.err.println("The input is not a .xyz file.");
                System.exit(1);
            }
            BufferedReader reader = isInternal ? new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(filename))) : new BufferedReader(new FileReader(filename));
            String line = reader.readLine();
            int i = 0;
            while (line != null) {
                String[] parts = line.split("\\s+");
                if (parts.length > 1) {
                    double x = Double.parseDouble(parts[1]);
                    double y = Double.parseDouble(parts[2]);
                    double z = Double.parseDouble(parts[3]);
                    int atomicNum = -1;
                    try {
                        atomicNum = Integer.parseInt(parts[0]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (atomicNum != -1) {
                        molecule.addAtom(atomicNum, x, y, z);
                    } else {
                        molecule.addAtom(parts[0], x, y, z);
                    }
                }
                line = reader.readLine();
                ++i;
            }
            reader.close();
        }
        catch (FileNotFoundException e) {
            System.err.println("File '" + filename + "' was not found");
            System.exit(1);
        }
        catch (IOException e) {
            System.err.println("File '" + filename + "' could not be read");
            System.exit(1);
        }
        return molecule;
    }
}

